package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  AccessControl,
  Grantee,
  GranteeType
}
import scala.jdk.CollectionConverters._
final case class Permission(
    granteeType: Option[GranteeType] = None,
    grantee: Option[Grantee] = None,
    access: Option[Iterable[AccessControl]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Permission = {
    import Permission.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Permission
      .builder()
      .optionallyWith(
        granteeType.map(value => GranteeType.unwrap(value): java.lang.String)
      )(_.granteeType)
      .optionallyWith(
        grantee.map(value => Grantee.unwrap(value): java.lang.String)
      )(_.grantee)
      .optionallyWith(
        access.map(value =>
          value.map { item =>
            AccessControl.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.access)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Permission.ReadOnly =
    zio.aws.elastictranscoder.model.Permission.wrap(buildAwsValue())
}
object Permission {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Permission
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Permission =
      zio.aws.elastictranscoder.model.Permission(
        granteeType.map(value => value),
        grantee.map(value => value),
        access.map(value => value)
      )
    def granteeType: Option[GranteeType]
    def grantee: Option[Grantee]
    def access: Option[List[AccessControl]]
    def getGranteeType: ZIO[Any, AwsError, GranteeType] =
      AwsError.unwrapOptionField("granteeType", granteeType)
    def getGrantee: ZIO[Any, AwsError, Grantee] =
      AwsError.unwrapOptionField("grantee", grantee)
    def getAccess: ZIO[Any, AwsError, List[AccessControl]] =
      AwsError.unwrapOptionField("access", access)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Permission
  ) extends zio.aws.elastictranscoder.model.Permission.ReadOnly {
    override val granteeType: Option[GranteeType] = scala
      .Option(impl.granteeType())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.GranteeType(value)
      )
    override val grantee: Option[Grantee] = scala
      .Option(impl.grantee())
      .map(value => zio.aws.elastictranscoder.model.primitives.Grantee(value))
    override val access: Option[List[AccessControl]] = scala
      .Option(impl.access())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.AccessControl(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Permission
  ): zio.aws.elastictranscoder.model.Permission.ReadOnly = new Wrapper(impl)
}
