package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  KeyStoragePolicy,
  ZeroTo255String,
  ZeroTo512String,
  Base64EncodedString,
  HlsContentProtectionMethod
}
import scala.jdk.CollectionConverters._
final case class HlsContentProtection(
    method: Option[HlsContentProtectionMethod] = None,
    key: Option[Base64EncodedString] = None,
    keyMd5: Option[Base64EncodedString] = None,
    initializationVector: Option[ZeroTo255String] = None,
    licenseAcquisitionUrl: Option[ZeroTo512String] = None,
    keyStoragePolicy: Option[KeyStoragePolicy] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection = {
    import HlsContentProtection.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection
      .builder()
      .optionallyWith(
        method.map(value =>
          HlsContentProtectionMethod.unwrap(value): java.lang.String
        )
      )(_.method)
      .optionallyWith(
        key.map(value => Base64EncodedString.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        keyMd5.map(value => Base64EncodedString.unwrap(value): java.lang.String)
      )(_.keyMd5)
      .optionallyWith(
        initializationVector.map(value =>
          ZeroTo255String.unwrap(value): java.lang.String
        )
      )(_.initializationVector)
      .optionallyWith(
        licenseAcquisitionUrl.map(value =>
          ZeroTo512String.unwrap(value): java.lang.String
        )
      )(_.licenseAcquisitionUrl)
      .optionallyWith(
        keyStoragePolicy.map(value =>
          KeyStoragePolicy.unwrap(value): java.lang.String
        )
      )(_.keyStoragePolicy)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly =
    zio.aws.elastictranscoder.model.HlsContentProtection.wrap(buildAwsValue())
}
object HlsContentProtection {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.HlsContentProtection =
      zio.aws.elastictranscoder.model.HlsContentProtection(
        method.map(value => value),
        key.map(value => value),
        keyMd5.map(value => value),
        initializationVector.map(value => value),
        licenseAcquisitionUrl.map(value => value),
        keyStoragePolicy.map(value => value)
      )
    def method: Option[HlsContentProtectionMethod]
    def key: Option[Base64EncodedString]
    def keyMd5: Option[Base64EncodedString]
    def initializationVector: Option[ZeroTo255String]
    def licenseAcquisitionUrl: Option[ZeroTo512String]
    def keyStoragePolicy: Option[KeyStoragePolicy]
    def getMethod: ZIO[Any, AwsError, HlsContentProtectionMethod] =
      AwsError.unwrapOptionField("method", method)
    def getKey: ZIO[Any, AwsError, Base64EncodedString] =
      AwsError.unwrapOptionField("key", key)
    def getKeyMd5: ZIO[Any, AwsError, Base64EncodedString] =
      AwsError.unwrapOptionField("keyMd5", keyMd5)
    def getInitializationVector: ZIO[Any, AwsError, ZeroTo255String] =
      AwsError.unwrapOptionField("initializationVector", initializationVector)
    def getLicenseAcquisitionUrl: ZIO[Any, AwsError, ZeroTo512String] =
      AwsError.unwrapOptionField("licenseAcquisitionUrl", licenseAcquisitionUrl)
    def getKeyStoragePolicy: ZIO[Any, AwsError, KeyStoragePolicy] =
      AwsError.unwrapOptionField("keyStoragePolicy", keyStoragePolicy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection
  ) extends zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly {
    override val method: Option[HlsContentProtectionMethod] = scala
      .Option(impl.method())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives
          .HlsContentProtectionMethod(value)
      )
    override val key: Option[Base64EncodedString] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Base64EncodedString(value)
      )
    override val keyMd5: Option[Base64EncodedString] = scala
      .Option(impl.keyMd5())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Base64EncodedString(value)
      )
    override val initializationVector: Option[ZeroTo255String] = scala
      .Option(impl.initializationVector())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ZeroTo255String(value)
      )
    override val licenseAcquisitionUrl: Option[ZeroTo512String] = scala
      .Option(impl.licenseAcquisitionUrl())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.ZeroTo512String(value)
      )
    override val keyStoragePolicy: Option[KeyStoragePolicy] = scala
      .Option(impl.keyStoragePolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.KeyStoragePolicy(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.HlsContentProtection
  ): zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly =
    new Wrapper(impl)
}
