package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  KeyArn,
  Role,
  BucketName,
  Name
}
import scala.jdk.CollectionConverters._
final case class CreatePipelineRequest(
    name: Name,
    inputBucket: BucketName,
    outputBucket: Option[BucketName] = None,
    role: Role,
    awsKmsKeyArn: Option[KeyArn] = None,
    notifications: Option[zio.aws.elastictranscoder.model.Notifications] = None,
    contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None,
    thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest = {
    import CreatePipelineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .inputBucket(BucketName.unwrap(inputBucket): java.lang.String)
      .optionallyWith(
        outputBucket.map(value => BucketName.unwrap(value): java.lang.String)
      )(_.outputBucket)
      .role(Role.unwrap(role): java.lang.String)
      .optionallyWith(
        awsKmsKeyArn.map(value => KeyArn.unwrap(value): java.lang.String)
      )(_.awsKmsKeyArn)
      .optionallyWith(notifications.map(value => value.buildAwsValue()))(
        _.notifications
      )
      .optionallyWith(contentConfig.map(value => value.buildAwsValue()))(
        _.contentConfig
      )
      .optionallyWith(thumbnailConfig.map(value => value.buildAwsValue()))(
        _.thumbnailConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly =
    zio.aws.elastictranscoder.model.CreatePipelineRequest.wrap(buildAwsValue())
}
object CreatePipelineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreatePipelineRequest =
      zio.aws.elastictranscoder.model.CreatePipelineRequest(
        name,
        inputBucket,
        outputBucket.map(value => value),
        role,
        awsKmsKeyArn.map(value => value),
        notifications.map(value => value.asEditable),
        contentConfig.map(value => value.asEditable),
        thumbnailConfig.map(value => value.asEditable)
      )
    def name: Name
    def inputBucket: BucketName
    def outputBucket: Option[BucketName]
    def role: Role
    def awsKmsKeyArn: Option[KeyArn]
    def notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly]
    def contentConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def thumbnailConfig
        : Option[zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getInputBucket: ZIO[Any, Nothing, BucketName] = ZIO.succeed(inputBucket)
    def getOutputBucket: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("outputBucket", outputBucket)
    def getRole: ZIO[Any, Nothing, Role] = ZIO.succeed(role)
    def getAwsKmsKeyArn: ZIO[Any, AwsError, KeyArn] =
      AwsError.unwrapOptionField("awsKmsKeyArn", awsKmsKeyArn)
    def getNotifications: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Notifications.ReadOnly
    ] = AwsError.unwrapOptionField("notifications", notifications)
    def getContentConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("contentConfig", contentConfig)
    def getThumbnailConfig: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField("thumbnailConfig", thumbnailConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ) extends zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly {
    override val name: Name =
      zio.aws.elastictranscoder.model.primitives.Name(impl.name())
    override val inputBucket: BucketName =
      zio.aws.elastictranscoder.model.primitives.BucketName(impl.inputBucket())
    override val outputBucket: Option[BucketName] = scala
      .Option(impl.outputBucket())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.BucketName(value)
      )
    override val role: Role =
      zio.aws.elastictranscoder.model.primitives.Role(impl.role())
    override val awsKmsKeyArn: Option[KeyArn] = scala
      .Option(impl.awsKmsKeyArn())
      .map(value => zio.aws.elastictranscoder.model.primitives.KeyArn(value))
    override val notifications
        : Option[zio.aws.elastictranscoder.model.Notifications.ReadOnly] = scala
      .Option(impl.notifications())
      .map(value => zio.aws.elastictranscoder.model.Notifications.wrap(value))
    override val contentConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.contentConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
    override val thumbnailConfig: Option[
      zio.aws.elastictranscoder.model.PipelineOutputConfig.ReadOnly
    ] = scala
      .Option(impl.thumbnailConfig())
      .map(value =>
        zio.aws.elastictranscoder.model.PipelineOutputConfig.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreatePipelineRequest
  ): zio.aws.elastictranscoder.model.CreatePipelineRequest.ReadOnly =
    new Wrapper(impl)
}
