package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{Key, Id}
import scala.jdk.CollectionConverters._
final case class CreateJobRequest(
    pipelineId: Id,
    input: Option[zio.aws.elastictranscoder.model.JobInput] = None,
    inputs: Option[Iterable[zio.aws.elastictranscoder.model.JobInput]] = None,
    output: Option[zio.aws.elastictranscoder.model.CreateJobOutput] = None,
    outputs: Option[Iterable[zio.aws.elastictranscoder.model.CreateJobOutput]] =
      None,
    outputKeyPrefix: Option[Key] = None,
    playlists: Option[
      Iterable[zio.aws.elastictranscoder.model.CreateJobPlaylist]
    ] = None,
    userMetadata: Option[Map[String, String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest = {
    import CreateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest
      .builder()
      .pipelineId(Id.unwrap(pipelineId): java.lang.String)
      .optionallyWith(input.map(value => value.buildAwsValue()))(_.input)
      .optionallyWith(
        inputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inputs)
      .optionallyWith(output.map(value => value.buildAwsValue()))(_.output)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        outputKeyPrefix.map(value => Key.unwrap(value): java.lang.String)
      )(_.outputKeyPrefix)
      .optionallyWith(
        playlists.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.playlists)
      .optionallyWith(
        userMetadata.map(value =>
          value
            .map({ case (key, value) =>
              (key: java.lang.String) -> (value: java.lang.String)
            })
            .asJava
        )
      )(_.userMetadata)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CreateJobRequest.ReadOnly =
    zio.aws.elastictranscoder.model.CreateJobRequest.wrap(buildAwsValue())
}
object CreateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CreateJobRequest =
      zio.aws.elastictranscoder.model.CreateJobRequest(
        pipelineId,
        input.map(value => value.asEditable),
        inputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        output.map(value => value.asEditable),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        outputKeyPrefix.map(value => value),
        playlists.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userMetadata.map(value => value)
      )
    def pipelineId: Id
    def input: Option[zio.aws.elastictranscoder.model.JobInput.ReadOnly]
    def inputs: Option[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]]
    def output: Option[zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly]
    def outputs
        : Option[List[zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly]]
    def outputKeyPrefix: Option[Key]
    def playlists: Option[
      List[zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly]
    ]
    def userMetadata: Option[Map[String, String]]
    def getPipelineId: ZIO[Any, Nothing, Id] = ZIO.succeed(pipelineId)
    def getInput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ] = AwsError.unwrapOptionField("input", input)
    def getInputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.JobInput.ReadOnly
    ]] = AwsError.unwrapOptionField("inputs", inputs)
    def getOutput: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly
    ] = AwsError.unwrapOptionField("output", output)
    def getOutputs: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("outputs", outputs)
    def getOutputKeyPrefix: ZIO[Any, AwsError, Key] =
      AwsError.unwrapOptionField("outputKeyPrefix", outputKeyPrefix)
    def getPlaylists: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly
    ]] = AwsError.unwrapOptionField("playlists", playlists)
    def getUserMetadata: ZIO[Any, AwsError, Map[String, String]] =
      AwsError.unwrapOptionField("userMetadata", userMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest
  ) extends zio.aws.elastictranscoder.model.CreateJobRequest.ReadOnly {
    override val pipelineId: Id =
      zio.aws.elastictranscoder.model.primitives.Id(impl.pipelineId())
    override val input
        : Option[zio.aws.elastictranscoder.model.JobInput.ReadOnly] = scala
      .Option(impl.input())
      .map(value => zio.aws.elastictranscoder.model.JobInput.wrap(value))
    override val inputs
        : Option[List[zio.aws.elastictranscoder.model.JobInput.ReadOnly]] =
      scala
        .Option(impl.inputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elastictranscoder.model.JobInput.wrap(item)
          }.toList
        )
    override val output
        : Option[zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly] =
      scala
        .Option(impl.output())
        .map(value =>
          zio.aws.elastictranscoder.model.CreateJobOutput.wrap(value)
        )
    override val outputs: Option[
      List[zio.aws.elastictranscoder.model.CreateJobOutput.ReadOnly]
    ] = scala
      .Option(impl.outputs())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.CreateJobOutput.wrap(item)
        }.toList
      )
    override val outputKeyPrefix: Option[Key] = scala
      .Option(impl.outputKeyPrefix())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val playlists: Option[
      List[zio.aws.elastictranscoder.model.CreateJobPlaylist.ReadOnly]
    ] = scala
      .Option(impl.playlists())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.CreateJobPlaylist.wrap(item)
        }.toList
      )
    override val userMetadata: Option[Map[String, String]] = scala
      .Option(impl.userMetadata())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            (key: String) -> (value: String)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CreateJobRequest
  ): zio.aws.elastictranscoder.model.CreateJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
