package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  Name,
  TimeOffset,
  Key,
  LongKey
}
import scala.jdk.CollectionConverters._
final case class CaptionSource(
    key: Option[LongKey] = None,
    language: Option[Key] = None,
    timeOffset: Option[TimeOffset] = None,
    label: Option[Name] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.CaptionSource = {
    import CaptionSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
      .builder()
      .optionallyWith(
        key.map(value => LongKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        language.map(value => Key.unwrap(value): java.lang.String)
      )(_.language)
      .optionallyWith(
        timeOffset.map(value => TimeOffset.unwrap(value): java.lang.String)
      )(_.timeOffset)
      .optionallyWith(label.map(value => Name.unwrap(value): java.lang.String))(
        _.label
      )
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.CaptionSource.ReadOnly =
    zio.aws.elastictranscoder.model.CaptionSource.wrap(buildAwsValue())
}
object CaptionSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.CaptionSource =
      zio.aws.elastictranscoder.model.CaptionSource(
        key.map(value => value),
        language.map(value => value),
        timeOffset.map(value => value),
        label.map(value => value),
        encryption.map(value => value.asEditable)
      )
    def key: Option[LongKey]
    def language: Option[Key]
    def timeOffset: Option[TimeOffset]
    def label: Option[Name]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def getKey: ZIO[Any, AwsError, LongKey] =
      AwsError.unwrapOptionField("key", key)
    def getLanguage: ZIO[Any, AwsError, Key] =
      AwsError.unwrapOptionField("language", language)
    def getTimeOffset: ZIO[Any, AwsError, TimeOffset] =
      AwsError.unwrapOptionField("timeOffset", timeOffset)
    def getLabel: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("label", label)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ) extends zio.aws.elastictranscoder.model.CaptionSource.ReadOnly {
    override val key: Option[LongKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.LongKey(value))
    override val language: Option[Key] = scala
      .Option(impl.language())
      .map(value => zio.aws.elastictranscoder.model.primitives.Key(value))
    override val timeOffset: Option[TimeOffset] = scala
      .Option(impl.timeOffset())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.TimeOffset(value)
      )
    override val label: Option[Name] = scala
      .Option(impl.label())
      .map(value => zio.aws.elastictranscoder.model.primitives.Name(value))
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.CaptionSource
  ): zio.aws.elastictranscoder.model.CaptionSource.ReadOnly = new Wrapper(impl)
}
