package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  CodecOption,
  FrameRate,
  DigitsOrAuto,
  MaxFrameRate,
  FixedGOP,
  KeyframesMaxDist,
  AspectRatio,
  VideoBitRate,
  PaddingPolicy,
  VideoCodec,
  SizingPolicy,
  Resolution
}
import scala.jdk.CollectionConverters._
final case class VideoParameters(
    codec: Option[VideoCodec] = None,
    codecOptions: Option[Map[CodecOption, CodecOption]] = None,
    keyframesMaxDist: Option[KeyframesMaxDist] = None,
    fixedGOP: Option[FixedGOP] = None,
    bitRate: Option[VideoBitRate] = None,
    frameRate: Option[FrameRate] = None,
    maxFrameRate: Option[MaxFrameRate] = None,
    resolution: Option[Resolution] = None,
    aspectRatio: Option[AspectRatio] = None,
    maxWidth: Option[DigitsOrAuto] = None,
    maxHeight: Option[DigitsOrAuto] = None,
    displayAspectRatio: Option[AspectRatio] = None,
    sizingPolicy: Option[SizingPolicy] = None,
    paddingPolicy: Option[PaddingPolicy] = None,
    watermarks: Option[
      Iterable[zio.aws.elastictranscoder.model.PresetWatermark]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.VideoParameters = {
    import VideoParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
      .builder()
      .optionallyWith(
        codec.map(value => VideoCodec.unwrap(value): java.lang.String)
      )(_.codec)
      .optionallyWith(
        codecOptions.map(value =>
          value
            .map({ case (key, value) =>
              (CodecOption.unwrap(key): java.lang.String) -> (CodecOption
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.codecOptions)
      .optionallyWith(
        keyframesMaxDist.map(value =>
          KeyframesMaxDist.unwrap(value): java.lang.String
        )
      )(_.keyframesMaxDist)
      .optionallyWith(
        fixedGOP.map(value => FixedGOP.unwrap(value): java.lang.String)
      )(_.fixedGOP)
      .optionallyWith(
        bitRate.map(value => VideoBitRate.unwrap(value): java.lang.String)
      )(_.bitRate)
      .optionallyWith(
        frameRate.map(value => FrameRate.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(
        maxFrameRate.map(value => MaxFrameRate.unwrap(value): java.lang.String)
      )(_.maxFrameRate)
      .optionallyWith(
        resolution.map(value => Resolution.unwrap(value): java.lang.String)
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        maxWidth.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxWidth)
      .optionallyWith(
        maxHeight.map(value => DigitsOrAuto.unwrap(value): java.lang.String)
      )(_.maxHeight)
      .optionallyWith(
        displayAspectRatio.map(value =>
          AspectRatio.unwrap(value): java.lang.String
        )
      )(_.displayAspectRatio)
      .optionallyWith(
        sizingPolicy.map(value => SizingPolicy.unwrap(value): java.lang.String)
      )(_.sizingPolicy)
      .optionallyWith(
        paddingPolicy.map(value =>
          PaddingPolicy.unwrap(value): java.lang.String
        )
      )(_.paddingPolicy)
      .optionallyWith(
        watermarks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.watermarks)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.VideoParameters.ReadOnly =
    zio.aws.elastictranscoder.model.VideoParameters.wrap(buildAwsValue())
}
object VideoParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.VideoParameters =
      zio.aws.elastictranscoder.model.VideoParameters(
        codec.map(value => value),
        codecOptions.map(value => value),
        keyframesMaxDist.map(value => value),
        fixedGOP.map(value => value),
        bitRate.map(value => value),
        frameRate.map(value => value),
        maxFrameRate.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        maxWidth.map(value => value),
        maxHeight.map(value => value),
        displayAspectRatio.map(value => value),
        sizingPolicy.map(value => value),
        paddingPolicy.map(value => value),
        watermarks.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def codec: Option[VideoCodec]
    def codecOptions: Option[Map[CodecOption, CodecOption]]
    def keyframesMaxDist: Option[KeyframesMaxDist]
    def fixedGOP: Option[FixedGOP]
    def bitRate: Option[VideoBitRate]
    def frameRate: Option[FrameRate]
    def maxFrameRate: Option[MaxFrameRate]
    def resolution: Option[Resolution]
    def aspectRatio: Option[AspectRatio]
    def maxWidth: Option[DigitsOrAuto]
    def maxHeight: Option[DigitsOrAuto]
    def displayAspectRatio: Option[AspectRatio]
    def sizingPolicy: Option[SizingPolicy]
    def paddingPolicy: Option[PaddingPolicy]
    def watermarks
        : Option[List[zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly]]
    def getCodec: ZIO[Any, AwsError, VideoCodec] =
      AwsError.unwrapOptionField("codec", codec)
    def getCodecOptions: ZIO[Any, AwsError, Map[CodecOption, CodecOption]] =
      AwsError.unwrapOptionField("codecOptions", codecOptions)
    def getKeyframesMaxDist: ZIO[Any, AwsError, KeyframesMaxDist] =
      AwsError.unwrapOptionField("keyframesMaxDist", keyframesMaxDist)
    def getFixedGOP: ZIO[Any, AwsError, FixedGOP] =
      AwsError.unwrapOptionField("fixedGOP", fixedGOP)
    def getBitRate: ZIO[Any, AwsError, VideoBitRate] =
      AwsError.unwrapOptionField("bitRate", bitRate)
    def getFrameRate: ZIO[Any, AwsError, FrameRate] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getMaxFrameRate: ZIO[Any, AwsError, MaxFrameRate] =
      AwsError.unwrapOptionField("maxFrameRate", maxFrameRate)
    def getResolution: ZIO[Any, AwsError, Resolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getMaxWidth: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxWidth", maxWidth)
    def getMaxHeight: ZIO[Any, AwsError, DigitsOrAuto] =
      AwsError.unwrapOptionField("maxHeight", maxHeight)
    def getDisplayAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("displayAspectRatio", displayAspectRatio)
    def getSizingPolicy: ZIO[Any, AwsError, SizingPolicy] =
      AwsError.unwrapOptionField("sizingPolicy", sizingPolicy)
    def getPaddingPolicy: ZIO[Any, AwsError, PaddingPolicy] =
      AwsError.unwrapOptionField("paddingPolicy", paddingPolicy)
    def getWatermarks: ZIO[Any, AwsError, List[
      zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly
    ]] = AwsError.unwrapOptionField("watermarks", watermarks)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ) extends zio.aws.elastictranscoder.model.VideoParameters.ReadOnly {
    override val codec: Option[VideoCodec] = scala
      .Option(impl.codec())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.VideoCodec(value)
      )
    override val codecOptions: Option[Map[CodecOption, CodecOption]] = scala
      .Option(impl.codecOptions())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.elastictranscoder.model.primitives.CodecOption(
              key
            ) -> zio.aws.elastictranscoder.model.primitives.CodecOption(value)
          })
          .toMap
      )
    override val keyframesMaxDist: Option[KeyframesMaxDist] = scala
      .Option(impl.keyframesMaxDist())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.KeyframesMaxDist(value)
      )
    override val fixedGOP: Option[FixedGOP] = scala
      .Option(impl.fixedGOP())
      .map(value => zio.aws.elastictranscoder.model.primitives.FixedGOP(value))
    override val bitRate: Option[VideoBitRate] = scala
      .Option(impl.bitRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.VideoBitRate(value)
      )
    override val frameRate: Option[FrameRate] = scala
      .Option(impl.frameRate())
      .map(value => zio.aws.elastictranscoder.model.primitives.FrameRate(value))
    override val maxFrameRate: Option[MaxFrameRate] = scala
      .Option(impl.maxFrameRate())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.MaxFrameRate(value)
      )
    override val resolution: Option[Resolution] = scala
      .Option(impl.resolution())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Resolution(value)
      )
    override val aspectRatio: Option[AspectRatio] = scala
      .Option(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val maxWidth: Option[DigitsOrAuto] = scala
      .Option(impl.maxWidth())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val maxHeight: Option[DigitsOrAuto] = scala
      .Option(impl.maxHeight())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.DigitsOrAuto(value)
      )
    override val displayAspectRatio: Option[AspectRatio] = scala
      .Option(impl.displayAspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val sizingPolicy: Option[SizingPolicy] = scala
      .Option(impl.sizingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.SizingPolicy(value)
      )
    override val paddingPolicy: Option[PaddingPolicy] = scala
      .Option(impl.paddingPolicy())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PaddingPolicy(value)
      )
    override val watermarks: Option[
      List[zio.aws.elastictranscoder.model.PresetWatermark.ReadOnly]
    ] = scala
      .Option(impl.watermarks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.PresetWatermark.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.VideoParameters
  ): zio.aws.elastictranscoder.model.VideoParameters.ReadOnly = new Wrapper(
    impl
  )
}
