package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  Key,
  Filename,
  JobStatus,
  Description,
  PlaylistFormat
}
import scala.jdk.CollectionConverters._
final case class Playlist(
    name: Option[Filename] = None,
    format: Option[PlaylistFormat] = None,
    outputKeys: Option[Iterable[Key]] = None,
    hlsContentProtection: Option[
      zio.aws.elastictranscoder.model.HlsContentProtection
    ] = None,
    playReadyDrm: Option[zio.aws.elastictranscoder.model.PlayReadyDrm] = None,
    status: Option[JobStatus] = None,
    statusDetail: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.Playlist = {
    import Playlist.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.Playlist
      .builder()
      .optionallyWith(
        name.map(value => Filename.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        format.map(value => PlaylistFormat.unwrap(value): java.lang.String)
      )(_.format)
      .optionallyWith(
        outputKeys.map(value =>
          value.map { item =>
            Key.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.outputKeys)
      .optionallyWith(hlsContentProtection.map(value => value.buildAwsValue()))(
        _.hlsContentProtection
      )
      .optionallyWith(playReadyDrm.map(value => value.buildAwsValue()))(
        _.playReadyDrm
      )
      .optionallyWith(
        status.map(value => JobStatus.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        statusDetail.map(value => Description.unwrap(value): java.lang.String)
      )(_.statusDetail)
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.Playlist.ReadOnly =
    zio.aws.elastictranscoder.model.Playlist.wrap(buildAwsValue())
}
object Playlist {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.Playlist =
      zio.aws.elastictranscoder.model.Playlist(
        name.map(value => value),
        format.map(value => value),
        outputKeys.map(value => value),
        hlsContentProtection.map(value => value.asEditable),
        playReadyDrm.map(value => value.asEditable),
        status.map(value => value),
        statusDetail.map(value => value)
      )
    def name: Option[Filename]
    def format: Option[PlaylistFormat]
    def outputKeys: Option[List[Key]]
    def hlsContentProtection
        : Option[zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly]
    def playReadyDrm
        : Option[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly]
    def status: Option[JobStatus]
    def statusDetail: Option[Description]
    def getName: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("name", name)
    def getFormat: ZIO[Any, AwsError, PlaylistFormat] =
      AwsError.unwrapOptionField("format", format)
    def getOutputKeys: ZIO[Any, AwsError, List[Key]] =
      AwsError.unwrapOptionField("outputKeys", outputKeys)
    def getHlsContentProtection: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = AwsError.unwrapOptionField("hlsContentProtection", hlsContentProtection)
    def getPlayReadyDrm: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly
    ] = AwsError.unwrapOptionField("playReadyDrm", playReadyDrm)
    def getStatus: ZIO[Any, AwsError, JobStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDetail: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("statusDetail", statusDetail)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ) extends zio.aws.elastictranscoder.model.Playlist.ReadOnly {
    override val name: Option[Filename] = scala
      .Option(impl.name())
      .map(value => zio.aws.elastictranscoder.model.primitives.Filename(value))
    override val format: Option[PlaylistFormat] = scala
      .Option(impl.format())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.PlaylistFormat(value)
      )
    override val outputKeys: Option[List[Key]] = scala
      .Option(impl.outputKeys())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elastictranscoder.model.primitives.Key(item)
        }.toList
      )
    override val hlsContentProtection: Option[
      zio.aws.elastictranscoder.model.HlsContentProtection.ReadOnly
    ] = scala
      .Option(impl.hlsContentProtection())
      .map(value =>
        zio.aws.elastictranscoder.model.HlsContentProtection.wrap(value)
      )
    override val playReadyDrm
        : Option[zio.aws.elastictranscoder.model.PlayReadyDrm.ReadOnly] = scala
      .Option(impl.playReadyDrm())
      .map(value => zio.aws.elastictranscoder.model.PlayReadyDrm.wrap(value))
    override val status: Option[JobStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.elastictranscoder.model.primitives.JobStatus(value))
    override val statusDetail: Option[Description] = scala
      .Option(impl.statusDetail())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.Playlist
  ): zio.aws.elastictranscoder.model.Playlist.ReadOnly = new Wrapper(impl)
}
