package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class UpdatePipelineStatusResponse(
    pipeline: Option[zio.aws.elastictranscoder.model.Pipeline] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse = {
    import UpdatePipelineStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse
      .builder()
      .optionallyWith(pipeline.map(value => value.buildAwsValue()))(_.pipeline)
      .build()
  }
  def asReadOnly
      : zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly =
    zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse
      .wrap(buildAwsValue())
}
object UpdatePipelineStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse =
      zio.aws.elastictranscoder.model
        .UpdatePipelineStatusResponse(pipeline.map(value => value.asEditable))
    def pipeline: Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly]
    def getPipeline: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Pipeline.ReadOnly
    ] = AwsError.unwrapOptionField("pipeline", pipeline)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse
  ) extends zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly {
    override val pipeline
        : Option[zio.aws.elastictranscoder.model.Pipeline.ReadOnly] = scala
      .Option(impl.pipeline())
      .map(value => zio.aws.elastictranscoder.model.Pipeline.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.UpdatePipelineStatusResponse
  ): zio.aws.elastictranscoder.model.UpdatePipelineStatusResponse.ReadOnly =
    new Wrapper(impl)
}
