package zio.aws.elastictranscoder.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elastictranscoder.model.primitives.{
  FrameRate,
  JobContainer,
  AspectRatio,
  LongKey,
  Interlaced,
  Resolution
}
import scala.jdk.CollectionConverters._
final case class JobInput(
    key: Option[LongKey] = None,
    frameRate: Option[FrameRate] = None,
    resolution: Option[Resolution] = None,
    aspectRatio: Option[AspectRatio] = None,
    interlaced: Option[Interlaced] = None,
    container: Option[JobContainer] = None,
    encryption: Option[zio.aws.elastictranscoder.model.Encryption] = None,
    timeSpan: Option[zio.aws.elastictranscoder.model.TimeSpan] = None,
    inputCaptions: Option[zio.aws.elastictranscoder.model.InputCaptions] = None,
    detectedProperties: Option[
      zio.aws.elastictranscoder.model.DetectedProperties
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elastictranscoder.model.JobInput = {
    import JobInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elastictranscoder.model.JobInput
      .builder()
      .optionallyWith(
        key.map(value => LongKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        frameRate.map(value => FrameRate.unwrap(value): java.lang.String)
      )(_.frameRate)
      .optionallyWith(
        resolution.map(value => Resolution.unwrap(value): java.lang.String)
      )(_.resolution)
      .optionallyWith(
        aspectRatio.map(value => AspectRatio.unwrap(value): java.lang.String)
      )(_.aspectRatio)
      .optionallyWith(
        interlaced.map(value => Interlaced.unwrap(value): java.lang.String)
      )(_.interlaced)
      .optionallyWith(
        container.map(value => JobContainer.unwrap(value): java.lang.String)
      )(_.container)
      .optionallyWith(encryption.map(value => value.buildAwsValue()))(
        _.encryption
      )
      .optionallyWith(timeSpan.map(value => value.buildAwsValue()))(_.timeSpan)
      .optionallyWith(inputCaptions.map(value => value.buildAwsValue()))(
        _.inputCaptions
      )
      .optionallyWith(detectedProperties.map(value => value.buildAwsValue()))(
        _.detectedProperties
      )
      .build()
  }
  def asReadOnly: zio.aws.elastictranscoder.model.JobInput.ReadOnly =
    zio.aws.elastictranscoder.model.JobInput.wrap(buildAwsValue())
}
object JobInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elastictranscoder.model.JobInput =
      zio.aws.elastictranscoder.model.JobInput(
        key.map(value => value),
        frameRate.map(value => value),
        resolution.map(value => value),
        aspectRatio.map(value => value),
        interlaced.map(value => value),
        container.map(value => value),
        encryption.map(value => value.asEditable),
        timeSpan.map(value => value.asEditable),
        inputCaptions.map(value => value.asEditable),
        detectedProperties.map(value => value.asEditable)
      )
    def key: Option[LongKey]
    def frameRate: Option[FrameRate]
    def resolution: Option[Resolution]
    def aspectRatio: Option[AspectRatio]
    def interlaced: Option[Interlaced]
    def container: Option[JobContainer]
    def encryption: Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly]
    def timeSpan: Option[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly]
    def inputCaptions
        : Option[zio.aws.elastictranscoder.model.InputCaptions.ReadOnly]
    def detectedProperties
        : Option[zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly]
    def getKey: ZIO[Any, AwsError, LongKey] =
      AwsError.unwrapOptionField("key", key)
    def getFrameRate: ZIO[Any, AwsError, FrameRate] =
      AwsError.unwrapOptionField("frameRate", frameRate)
    def getResolution: ZIO[Any, AwsError, Resolution] =
      AwsError.unwrapOptionField("resolution", resolution)
    def getAspectRatio: ZIO[Any, AwsError, AspectRatio] =
      AwsError.unwrapOptionField("aspectRatio", aspectRatio)
    def getInterlaced: ZIO[Any, AwsError, Interlaced] =
      AwsError.unwrapOptionField("interlaced", interlaced)
    def getContainer: ZIO[Any, AwsError, JobContainer] =
      AwsError.unwrapOptionField("container", container)
    def getEncryption: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.Encryption.ReadOnly
    ] = AwsError.unwrapOptionField("encryption", encryption)
    def getTimeSpan: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.TimeSpan.ReadOnly
    ] = AwsError.unwrapOptionField("timeSpan", timeSpan)
    def getInputCaptions: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.InputCaptions.ReadOnly
    ] = AwsError.unwrapOptionField("inputCaptions", inputCaptions)
    def getDetectedProperties: ZIO[
      Any,
      AwsError,
      zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly
    ] = AwsError.unwrapOptionField("detectedProperties", detectedProperties)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ) extends zio.aws.elastictranscoder.model.JobInput.ReadOnly {
    override val key: Option[LongKey] = scala
      .Option(impl.key())
      .map(value => zio.aws.elastictranscoder.model.primitives.LongKey(value))
    override val frameRate: Option[FrameRate] = scala
      .Option(impl.frameRate())
      .map(value => zio.aws.elastictranscoder.model.primitives.FrameRate(value))
    override val resolution: Option[Resolution] = scala
      .Option(impl.resolution())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Resolution(value)
      )
    override val aspectRatio: Option[AspectRatio] = scala
      .Option(impl.aspectRatio())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.AspectRatio(value)
      )
    override val interlaced: Option[Interlaced] = scala
      .Option(impl.interlaced())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.Interlaced(value)
      )
    override val container: Option[JobContainer] = scala
      .Option(impl.container())
      .map(value =>
        zio.aws.elastictranscoder.model.primitives.JobContainer(value)
      )
    override val encryption
        : Option[zio.aws.elastictranscoder.model.Encryption.ReadOnly] = scala
      .Option(impl.encryption())
      .map(value => zio.aws.elastictranscoder.model.Encryption.wrap(value))
    override val timeSpan
        : Option[zio.aws.elastictranscoder.model.TimeSpan.ReadOnly] = scala
      .Option(impl.timeSpan())
      .map(value => zio.aws.elastictranscoder.model.TimeSpan.wrap(value))
    override val inputCaptions
        : Option[zio.aws.elastictranscoder.model.InputCaptions.ReadOnly] = scala
      .Option(impl.inputCaptions())
      .map(value => zio.aws.elastictranscoder.model.InputCaptions.wrap(value))
    override val detectedProperties
        : Option[zio.aws.elastictranscoder.model.DetectedProperties.ReadOnly] =
      scala
        .Option(impl.detectedProperties())
        .map(value =>
          zio.aws.elastictranscoder.model.DetectedProperties.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elastictranscoder.model.JobInput
  ): zio.aws.elastictranscoder.model.JobInput.ReadOnly = new Wrapper(impl)
}
