package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListVpcEndpointsResponse(
    vpcEndpointSummaryList: Iterable[
      zio.aws.elasticsearch.model.VpcEndpointSummary
    ],
    nextToken: NextToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse = {
    import ListVpcEndpointsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse
      .builder()
      .vpcEndpointSummaryList(vpcEndpointSummaryList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .nextToken(NextToken.unwrap(nextToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListVpcEndpointsResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListVpcEndpointsResponse.wrap(buildAwsValue())
}
object ListVpcEndpointsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListVpcEndpointsResponse =
      zio.aws.elasticsearch.model.ListVpcEndpointsResponse(
        vpcEndpointSummaryList.map { item =>
          item.asEditable
        },
        nextToken
      )
    def vpcEndpointSummaryList
        : List[zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly]
    def nextToken: NextToken
    def getVpcEndpointSummaryList: ZIO[Any, Nothing, List[
      zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly
    ]] = ZIO.succeed(vpcEndpointSummaryList)
    def getNextToken: ZIO[Any, Nothing, NextToken] = ZIO.succeed(nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse
  ) extends zio.aws.elasticsearch.model.ListVpcEndpointsResponse.ReadOnly {
    override val vpcEndpointSummaryList
        : List[zio.aws.elasticsearch.model.VpcEndpointSummary.ReadOnly] = impl
      .vpcEndpointSummaryList()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.VpcEndpointSummary.wrap(item)
      }
      .toList
    override val nextToken: NextToken =
      zio.aws.elasticsearch.model.primitives.NextToken(impl.nextToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsResponse
  ): zio.aws.elasticsearch.model.ListVpcEndpointsResponse.ReadOnly =
    new Wrapper(impl)
}
