package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{
  InstanceCount,
  ReservationToken,
  GUID
}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedElasticsearchInstanceOfferingRequest(
    reservedElasticsearchInstanceOfferingId: GUID,
    reservationName: ReservationToken,
    instanceCount: Optional[InstanceCount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest = {
    import PurchaseReservedElasticsearchInstanceOfferingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest
      .builder()
      .reservedElasticsearchInstanceOfferingId(
        GUID.unwrap(reservedElasticsearchInstanceOfferingId): java.lang.String
      )
      .reservationName(
        ReservationToken.unwrap(reservationName): java.lang.String
      )
      .optionallyWith(
        instanceCount.map(value => InstanceCount.unwrap(value): Integer)
      )(_.instanceCount)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest.ReadOnly =
    zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest
      .wrap(buildAwsValue())
}
object PurchaseReservedElasticsearchInstanceOfferingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest =
      zio.aws.elasticsearch.model
        .PurchaseReservedElasticsearchInstanceOfferingRequest(
          reservedElasticsearchInstanceOfferingId,
          reservationName,
          instanceCount.map(value => value)
        )
    def reservedElasticsearchInstanceOfferingId: GUID
    def reservationName: ReservationToken
    def instanceCount: Optional[InstanceCount]
    def getReservedElasticsearchInstanceOfferingId: ZIO[Any, Nothing, GUID] =
      ZIO.succeed(reservedElasticsearchInstanceOfferingId)
    def getReservationName: ZIO[Any, Nothing, ReservationToken] =
      ZIO.succeed(reservationName)
    def getInstanceCount: ZIO[Any, AwsError, InstanceCount] =
      AwsError.unwrapOptionField("instanceCount", instanceCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest
  ) extends zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest.ReadOnly {
    override val reservedElasticsearchInstanceOfferingId: GUID =
      zio.aws.elasticsearch.model.primitives
        .GUID(impl.reservedElasticsearchInstanceOfferingId())
    override val reservationName: ReservationToken =
      zio.aws.elasticsearch.model.primitives
        .ReservationToken(impl.reservationName())
    override val instanceCount: Optional[InstanceCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceCount())
      .map(value => zio.aws.elasticsearch.model.primitives.InstanceCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest
  ): zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingRequest.ReadOnly =
    new Wrapper(impl)
}
