package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeElasticsearchDomainsRequest(
    domainNames: Iterable[DomainName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest = {
    import DescribeElasticsearchDomainsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest
      .builder()
      .domainNames(domainNames.map { item =>
        DomainName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchDomainsRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainsRequest
      .wrap(buildAwsValue())
}
object DescribeElasticsearchDomainsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchDomainsRequest =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchDomainsRequest(domainNames)
    def domainNames: List[DomainName]
    def getDomainNames: ZIO[Any, Nothing, List[DomainName]] =
      ZIO.succeed(domainNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchDomainsRequest.ReadOnly {
    override val domainNames: List[DomainName] = impl
      .domainNames()
      .asScala
      .map { item =>
        zio.aws.elasticsearch.model.primitives.DomainName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsRequest
  ): zio.aws.elasticsearch.model.DescribeElasticsearchDomainsRequest.ReadOnly =
    new Wrapper(impl)
}
