package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{NextToken, DomainName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListVpcEndpointsForDomainRequest(
    domainName: DomainName,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest = {
    import ListVpcEndpointsForDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest
      .builder()
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest
      .wrap(buildAwsValue())
}
object ListVpcEndpointsForDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest =
      zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest(
        domainName,
        nextToken.map(value => value)
      )
    def domainName: DomainName
    def nextToken: Optional[NextToken]
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest
  ) extends zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest.ReadOnly {
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListVpcEndpointsForDomainRequest
  ): zio.aws.elasticsearch.model.ListVpcEndpointsForDomainRequest.ReadOnly =
    new Wrapper(impl)
}
