package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{SAMLEntityId, SAMLMetadata}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SAMLIdp(
    metadataContent: SAMLMetadata,
    entityId: SAMLEntityId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SAMLIdp = {
    import SAMLIdp.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SAMLIdp
      .builder()
      .metadataContent(SAMLMetadata.unwrap(metadataContent): java.lang.String)
      .entityId(SAMLEntityId.unwrap(entityId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SAMLIdp.ReadOnly =
    zio.aws.elasticsearch.model.SAMLIdp.wrap(buildAwsValue())
}
object SAMLIdp {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SAMLIdp
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SAMLIdp =
      zio.aws.elasticsearch.model.SAMLIdp(metadataContent, entityId)
    def metadataContent: SAMLMetadata
    def entityId: SAMLEntityId
    def getMetadataContent: ZIO[Any, Nothing, SAMLMetadata] =
      ZIO.succeed(metadataContent)
    def getEntityId: ZIO[Any, Nothing, SAMLEntityId] = ZIO.succeed(entityId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLIdp
  ) extends zio.aws.elasticsearch.model.SAMLIdp.ReadOnly {
    override val metadataContent: SAMLMetadata =
      zio.aws.elasticsearch.model.primitives
        .SAMLMetadata(impl.metadataContent())
    override val entityId: SAMLEntityId =
      zio.aws.elasticsearch.model.primitives.SAMLEntityId(impl.entityId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SAMLIdp
  ): zio.aws.elasticsearch.model.SAMLIdp.ReadOnly = new Wrapper(impl)
}
