package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{DomainName, PackageID}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DissociatePackageRequest(
    packageID: PackageID,
    domainName: DomainName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest = {
    import DissociatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest
      .builder()
      .packageID(PackageID.unwrap(packageID): java.lang.String)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DissociatePackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.DissociatePackageRequest.wrap(buildAwsValue())
}
object DissociatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DissociatePackageRequest =
      zio.aws.elasticsearch.model
        .DissociatePackageRequest(packageID, domainName)
    def packageID: PackageID
    def domainName: DomainName
    def getPackageID: ZIO[Any, Nothing, PackageID] = ZIO.succeed(packageID)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest
  ) extends zio.aws.elasticsearch.model.DissociatePackageRequest.ReadOnly {
    override val packageID: PackageID =
      zio.aws.elasticsearch.model.primitives.PackageID(impl.packageID())
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DissociatePackageRequest
  ): zio.aws.elasticsearch.model.DissociatePackageRequest.ReadOnly =
    new Wrapper(impl)
}
