package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DescribePackagesFilterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePackagesFilter(
    name: Optional[zio.aws.elasticsearch.model.DescribePackagesFilterName] =
      Optional.Absent,
    value: Optional[Iterable[DescribePackagesFilterValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilter = {
    import DescribePackagesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilter
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        value.map(value =>
          value.map { item =>
            DescribePackagesFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly =
    zio.aws.elasticsearch.model.DescribePackagesFilter.wrap(buildAwsValue())
}
object DescribePackagesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribePackagesFilter =
      zio.aws.elasticsearch.model.DescribePackagesFilter(
        name.map(value => value),
        value.map(value => value)
      )
    def name: Optional[zio.aws.elasticsearch.model.DescribePackagesFilterName]
    def value: Optional[List[DescribePackagesFilterValue]]
    def getName: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.DescribePackagesFilterName
    ] = AwsError.unwrapOptionField("name", name)
    def getValue: ZIO[Any, AwsError, List[DescribePackagesFilterValue]] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilter
  ) extends zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly {
    override val name
        : Optional[zio.aws.elasticsearch.model.DescribePackagesFilterName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.elasticsearch.model.DescribePackagesFilterName.wrap(value)
        )
    override val value: Optional[List[DescribePackagesFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.primitives
              .DescribePackagesFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesFilter
  ): zio.aws.elasticsearch.model.DescribePackagesFilter.ReadOnly = new Wrapper(
    impl
  )
}
