package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateVpcEndpointResponse(
    vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse = {
    import UpdateVpcEndpointResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse
      .builder()
      .vpcEndpoint(vpcEndpoint.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.UpdateVpcEndpointResponse.ReadOnly =
    zio.aws.elasticsearch.model.UpdateVpcEndpointResponse.wrap(buildAwsValue())
}
object UpdateVpcEndpointResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpdateVpcEndpointResponse =
      zio.aws.elasticsearch.model
        .UpdateVpcEndpointResponse(vpcEndpoint.asEditable)
    def vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly
    def getVpcEndpoint
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly] =
      ZIO.succeed(vpcEndpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse
  ) extends zio.aws.elasticsearch.model.UpdateVpcEndpointResponse.ReadOnly {
    override val vpcEndpoint: zio.aws.elasticsearch.model.VpcEndpoint.ReadOnly =
      zio.aws.elasticsearch.model.VpcEndpoint.wrap(impl.vpcEndpoint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdateVpcEndpointResponse
  ): zio.aws.elasticsearch.model.UpdateVpcEndpointResponse.ReadOnly =
    new Wrapper(impl)
}
