package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdatePackageResponse(
    packageDetails: Optional[zio.aws.elasticsearch.model.PackageDetails] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse = {
    import UpdatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse
      .builder()
      .optionallyWith(packageDetails.map(value => value.buildAwsValue()))(
        _.packageDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly =
    zio.aws.elasticsearch.model.UpdatePackageResponse.wrap(buildAwsValue())
}
object UpdatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.UpdatePackageResponse =
      zio.aws.elasticsearch.model
        .UpdatePackageResponse(packageDetails.map(value => value.asEditable))
    def packageDetails
        : Optional[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]
    def getPackageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("packageDetails", packageDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse
  ) extends zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly {
    override val packageDetails
        : Optional[zio.aws.elasticsearch.model.PackageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDetails())
        .map(value => zio.aws.elasticsearch.model.PackageDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.UpdatePackageResponse
  ): zio.aws.elasticsearch.model.UpdatePackageResponse.ReadOnly = new Wrapper(
    impl
  )
}
