package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribePackagesResponse(
    packageDetailsList: Optional[
      Iterable[zio.aws.elasticsearch.model.PackageDetails]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse = {
    import DescribePackagesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
      .builder()
      .optionallyWith(
        packageDetailsList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageDetailsList)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribePackagesResponse.wrap(buildAwsValue())
}
object DescribePackagesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DescribePackagesResponse =
      zio.aws.elasticsearch.model.DescribePackagesResponse(
        packageDetailsList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def packageDetailsList
        : Optional[List[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]]
    def nextToken: Optional[String]
    def getPackageDetailsList: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.PackageDetails.ReadOnly
    ]] = AwsError.unwrapOptionField("packageDetailsList", packageDetailsList)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ) extends zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly {
    override val packageDetailsList
        : Optional[List[zio.aws.elasticsearch.model.PackageDetails.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDetailsList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.PackageDetails.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribePackagesResponse
  ): zio.aws.elasticsearch.model.DescribePackagesResponse.ReadOnly =
    new Wrapper(impl)
}
