package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeDomainAutoTunesResponse(
    autoTunes: Optional[Iterable[zio.aws.elasticsearch.model.AutoTune]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse = {
    import DescribeDomainAutoTunesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse
      .builder()
      .optionallyWith(
        autoTunes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.autoTunes)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse
      .wrap(buildAwsValue())
}
object DescribeDomainAutoTunesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse =
      zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse(
        autoTunes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def autoTunes: Optional[List[zio.aws.elasticsearch.model.AutoTune.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAutoTunes: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.AutoTune.ReadOnly
    ]] = AwsError.unwrapOptionField("autoTunes", autoTunes)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse
  ) extends zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly {
    override val autoTunes
        : Optional[List[zio.aws.elasticsearch.model.AutoTune.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.autoTunes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.AutoTune.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeDomainAutoTunesResponse
  ): zio.aws.elasticsearch.model.DescribeDomainAutoTunesResponse.ReadOnly =
    new Wrapper(impl)
}
