package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait OverallChangeStatus {
  def unwrap
      : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus
}
object OverallChangeStatus {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus
  ): zio.aws.elasticsearch.model.OverallChangeStatus = value match {
    case software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.elasticsearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.PENDING
  }
  case object PROCESSING
      extends zio.aws.elasticsearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.PROCESSING
  }
  case object COMPLETED
      extends zio.aws.elasticsearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.COMPLETED
  }
  case object FAILED extends zio.aws.elasticsearch.model.OverallChangeStatus {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus =
      software.amazon.awssdk.services.elasticsearch.model.OverallChangeStatus.FAILED
  }
}
