package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AutoTuneOptionsInput(
    desiredState: Optional[zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      Optional.Absent,
    maintenanceSchedules: Optional[
      Iterable[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput = {
    import AutoTuneOptionsInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
      .builder()
      .optionallyWith(desiredState.map(value => value.unwrap))(_.desiredState)
      .optionallyWith(
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.maintenanceSchedules)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsInput.wrap(buildAwsValue())
}
object AutoTuneOptionsInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsInput =
      zio.aws.elasticsearch.model.AutoTuneOptionsInput(
        desiredState.map(value => value),
        maintenanceSchedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def desiredState: Optional[zio.aws.elasticsearch.model.AutoTuneDesiredState]
    def maintenanceSchedules: Optional[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getMaintenanceSchedules: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("maintenanceSchedules", maintenanceSchedules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly {
    override val desiredState
        : Optional[zio.aws.elasticsearch.model.AutoTuneDesiredState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredState())
        .map(value =>
          zio.aws.elasticsearch.model.AutoTuneDesiredState.wrap(value)
        )
    override val maintenanceSchedules: Optional[
      List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.maintenanceSchedules())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsInput
  ): zio.aws.elasticsearch.model.AutoTuneOptionsInput.ReadOnly = new Wrapper(
    impl
  )
}
