package zio.aws.elasticsearch.model
import scala.jdk.CollectionConverters.*
sealed trait VolumeType {
  def unwrap: software.amazon.awssdk.services.elasticsearch.model.VolumeType
}
object VolumeType {
  def wrap(
      value: software.amazon.awssdk.services.elasticsearch.model.VolumeType
  ): zio.aws.elasticsearch.model.VolumeType = value match {
    case software.amazon.awssdk.services.elasticsearch.model.VolumeType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.elasticsearch.model.VolumeType.STANDARD =>
      val r = standard
      r
    case software.amazon.awssdk.services.elasticsearch.model.VolumeType.GP2 =>
      val r = gp2
      r
    case software.amazon.awssdk.services.elasticsearch.model.VolumeType.IO1 =>
      val r = io1
      r
    case software.amazon.awssdk.services.elasticsearch.model.VolumeType.GP3 =>
      val r = gp3
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.elasticsearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VolumeType =
      software.amazon.awssdk.services.elasticsearch.model.VolumeType.UNKNOWN_TO_SDK_VERSION
  }
  case object standard extends zio.aws.elasticsearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VolumeType =
      software.amazon.awssdk.services.elasticsearch.model.VolumeType.STANDARD
  }
  case object gp2 extends zio.aws.elasticsearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VolumeType =
      software.amazon.awssdk.services.elasticsearch.model.VolumeType.GP2
  }
  case object io1 extends zio.aws.elasticsearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VolumeType =
      software.amazon.awssdk.services.elasticsearch.model.VolumeType.IO1
  }
  case object gp3 extends zio.aws.elasticsearch.model.VolumeType {
    override def unwrap
        : software.amazon.awssdk.services.elasticsearch.model.VolumeType =
      software.amazon.awssdk.services.elasticsearch.model.VolumeType.GP3
  }
}
