package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EncryptionAtRestOptionsStatus(
    options: zio.aws.elasticsearch.model.EncryptionAtRestOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus = {
    import EncryptionAtRestOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus
      .wrap(buildAwsValue())
}
object EncryptionAtRestOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus =
      zio.aws.elasticsearch.model
        .EncryptionAtRestOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus
  ) extends zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly {
    override val options
        : zio.aws.elasticsearch.model.EncryptionAtRestOptions.ReadOnly =
      zio.aws.elasticsearch.model.EncryptionAtRestOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.EncryptionAtRestOptionsStatus
  ): zio.aws.elasticsearch.model.EncryptionAtRestOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
