package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CognitoOptionsStatus(
    options: zio.aws.elasticsearch.model.CognitoOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus = {
    import CognitoOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.CognitoOptionsStatus.wrap(buildAwsValue())
}
object CognitoOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CognitoOptionsStatus =
      zio.aws.elasticsearch.model
        .CognitoOptionsStatus(options.asEditable, status.asEditable)
    def options: zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.CognitoOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus
  ) extends zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly {
    override val options: zio.aws.elasticsearch.model.CognitoOptions.ReadOnly =
      zio.aws.elasticsearch.model.CognitoOptions.wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CognitoOptionsStatus
  ): zio.aws.elasticsearch.model.CognitoOptionsStatus.ReadOnly = new Wrapper(
    impl
  )
}
