package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DescribeElasticsearchDomainsResponse(
    domainStatusList: Iterable[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse = {
    import DescribeElasticsearchDomainsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse
      .builder()
      .domainStatusList(domainStatusList.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse
      .wrap(buildAwsValue())
}
object DescribeElasticsearchDomainsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchDomainsResponse(domainStatusList.map { item =>
          item.asEditable
        })
    def domainStatusList
        : List[zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly]
    def getDomainStatusList: ZIO[Any, Nothing, List[
      zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly
    ]] = ZIO.succeed(domainStatusList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly {
    override val domainStatusList
        : List[zio.aws.elasticsearch.model.ElasticsearchDomainStatus.ReadOnly] =
      impl
        .domainStatusList()
        .asScala
        .map { item =>
          zio.aws.elasticsearch.model.ElasticsearchDomainStatus.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchDomainsResponse
  ): zio.aws.elasticsearch.model.DescribeElasticsearchDomainsResponse.ReadOnly =
    new Wrapper(impl)
}
