package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DurationValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Duration(
    value: Optional[DurationValue] = Optional.Absent,
    unit: Optional[zio.aws.elasticsearch.model.TimeUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.Duration = {
    import Duration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.Duration
      .builder()
      .optionallyWith(
        value.map(value => DurationValue.unwrap(value): java.lang.Long)
      )(_.value)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.Duration.ReadOnly =
    zio.aws.elasticsearch.model.Duration.wrap(buildAwsValue())
}
object Duration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.Duration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.Duration =
      zio.aws.elasticsearch.model
        .Duration(value.map(value => value), unit.map(value => value))
    def value: Optional[DurationValue]
    def unit: Optional[zio.aws.elasticsearch.model.TimeUnit]
    def getValue: ZIO[Any, AwsError, DurationValue] =
      AwsError.unwrapOptionField("value", value)
    def getUnit: ZIO[Any, AwsError, zio.aws.elasticsearch.model.TimeUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.Duration
  ) extends zio.aws.elasticsearch.model.Duration.ReadOnly {
    override val value: Optional[DurationValue] = zio.aws.core.internal
      .optionalFromNullable(impl.value())
      .map(value => zio.aws.elasticsearch.model.primitives.DurationValue(value))
    override val unit: Optional[zio.aws.elasticsearch.model.TimeUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.elasticsearch.model.TimeUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.Duration
  ): zio.aws.elasticsearch.model.Duration.ReadOnly = new Wrapper(impl)
}
