package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCompatibleElasticsearchVersionsRequest(
    domainName: Optional[DomainName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest = {
    import GetCompatibleElasticsearchVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest.ReadOnly =
    zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest
      .wrap(buildAwsValue())
}
object GetCompatibleElasticsearchVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest =
      zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest(
        domainName.map(value => value)
      )
    def domainName: Optional[DomainName]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest
  ) extends zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest
  ): zio.aws.elasticsearch.model.GetCompatibleElasticsearchVersionsRequest.ReadOnly =
    new Wrapper(impl)
}
