package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{PackageDescription, PackageName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreatePackageRequest(
    packageName: PackageName,
    packageType: zio.aws.elasticsearch.model.PackageType,
    packageDescription: Optional[PackageDescription] = Optional.Absent,
    packageSource: zio.aws.elasticsearch.model.PackageSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest = {
    import CreatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest
      .builder()
      .packageName(PackageName.unwrap(packageName): java.lang.String)
      .packageType(packageType.unwrap)
      .optionallyWith(
        packageDescription.map(value =>
          PackageDescription.unwrap(value): java.lang.String
        )
      )(_.packageDescription)
      .packageSource(packageSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.CreatePackageRequest.ReadOnly =
    zio.aws.elasticsearch.model.CreatePackageRequest.wrap(buildAwsValue())
}
object CreatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.CreatePackageRequest =
      zio.aws.elasticsearch.model.CreatePackageRequest(
        packageName,
        packageType,
        packageDescription.map(value => value),
        packageSource.asEditable
      )
    def packageName: PackageName
    def packageType: zio.aws.elasticsearch.model.PackageType
    def packageDescription: Optional[PackageDescription]
    def packageSource: zio.aws.elasticsearch.model.PackageSource.ReadOnly
    def getPackageName: ZIO[Any, Nothing, PackageName] =
      ZIO.succeed(packageName)
    def getPackageType
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.PackageType] =
      ZIO.succeed(packageType)
    def getPackageDescription: ZIO[Any, AwsError, PackageDescription] =
      AwsError.unwrapOptionField("packageDescription", packageDescription)
    def getPackageSource: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.PackageSource.ReadOnly
    ] = ZIO.succeed(packageSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest
  ) extends zio.aws.elasticsearch.model.CreatePackageRequest.ReadOnly {
    override val packageName: PackageName =
      zio.aws.elasticsearch.model.primitives.PackageName(impl.packageName())
    override val packageType: zio.aws.elasticsearch.model.PackageType =
      zio.aws.elasticsearch.model.PackageType.wrap(impl.packageType())
    override val packageDescription: Optional[PackageDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageDescription())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.PackageDescription(value)
        )
    override val packageSource
        : zio.aws.elasticsearch.model.PackageSource.ReadOnly =
      zio.aws.elasticsearch.model.PackageSource.wrap(impl.packageSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreatePackageRequest
  ): zio.aws.elasticsearch.model.CreatePackageRequest.ReadOnly = new Wrapper(
    impl
  )
}
