package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RecurringCharge(
    recurringChargeAmount: Optional[Double] = Optional.Absent,
    recurringChargeFrequency: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.RecurringCharge = {
    import RecurringCharge.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.RecurringCharge
      .builder()
      .optionallyWith(
        recurringChargeAmount.map(value => value: java.lang.Double)
      )(_.recurringChargeAmount)
      .optionallyWith(
        recurringChargeFrequency.map(value => value: java.lang.String)
      )(_.recurringChargeFrequency)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.RecurringCharge.ReadOnly =
    zio.aws.elasticsearch.model.RecurringCharge.wrap(buildAwsValue())
}
object RecurringCharge {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.RecurringCharge
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.RecurringCharge =
      zio.aws.elasticsearch.model.RecurringCharge(
        recurringChargeAmount.map(value => value),
        recurringChargeFrequency.map(value => value)
      )
    def recurringChargeAmount: Optional[Double]
    def recurringChargeFrequency: Optional[String]
    def getRecurringChargeAmount: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("recurringChargeAmount", recurringChargeAmount)
    def getRecurringChargeFrequency: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("recurringChargeFrequency", recurringChargeFrequency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.RecurringCharge
  ) extends zio.aws.elasticsearch.model.RecurringCharge.ReadOnly {
    override val recurringChargeAmount: Optional[Double] = zio.aws.core.internal
      .optionalFromNullable(impl.recurringChargeAmount())
      .map(value => value: Double)
    override val recurringChargeFrequency: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recurringChargeFrequency())
        .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.RecurringCharge
  ): zio.aws.elasticsearch.model.RecurringCharge.ReadOnly = new Wrapper(impl)
}
