package zio.aws.elasticsearch
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DescribePackagesFilterValue,
  Issue,
  InstanceRole,
  DomainName,
  ServiceUrl,
  LimitValue,
  NonEmptyString
}
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.elasticsearch.model.primitives.AutoTuneDate.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ARN extends Subtype[String]
    type ARN = zio.aws.elasticsearch.model.primitives.ARN.Type
    object AutoTuneDate extends Subtype[Instant]
    type AutoTuneDate = zio.aws.elasticsearch.model.primitives.AutoTuneDate.Type
    object BackendRole extends Subtype[String]
    type BackendRole = zio.aws.elasticsearch.model.primitives.BackendRole.Type
    object ChangeProgressStageName extends Subtype[String]
    type ChangeProgressStageName =
      zio.aws.elasticsearch.model.primitives.ChangeProgressStageName.Type
    object ChangeProgressStageStatus extends Subtype[String]
    type ChangeProgressStageStatus =
      zio.aws.elasticsearch.model.primitives.ChangeProgressStageStatus.Type
    object CloudWatchLogsLogGroupArn extends Subtype[String]
    type CloudWatchLogsLogGroupArn =
      zio.aws.elasticsearch.model.primitives.CloudWatchLogsLogGroupArn.Type
    object CommitMessage extends Subtype[String]
    type CommitMessage =
      zio.aws.elasticsearch.model.primitives.CommitMessage.Type
    object ConnectionAlias extends Subtype[String]
    type ConnectionAlias =
      zio.aws.elasticsearch.model.primitives.ConnectionAlias.Type
    object CreatedAt extends Subtype[Instant]
    type CreatedAt = zio.aws.elasticsearch.model.primitives.CreatedAt.Type
    object CrossClusterSearchConnectionId extends Subtype[String]
    type CrossClusterSearchConnectionId =
      zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionId.Type
    object CrossClusterSearchConnectionStatusMessage extends Subtype[String]
    type CrossClusterSearchConnectionStatusMessage =
      zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionStatusMessage.Type
    object DeploymentCloseDateTimeStamp extends Subtype[Instant]
    type DeploymentCloseDateTimeStamp =
      zio.aws.elasticsearch.model.primitives.DeploymentCloseDateTimeStamp.Type
    object DeploymentType extends Subtype[String]
    type DeploymentType =
      zio.aws.elasticsearch.model.primitives.DeploymentType.Type
    object DescribePackagesFilterValue extends Subtype[String]
    type DescribePackagesFilterValue =
      zio.aws.elasticsearch.model.primitives.DescribePackagesFilterValue.Type
    object Description extends Subtype[String]
    type Description = zio.aws.elasticsearch.model.primitives.Description.Type
    object DisableTimestamp extends Subtype[Instant]
    type DisableTimestamp =
      zio.aws.elasticsearch.model.primitives.DisableTimestamp.Type
    object DomainId extends Subtype[String]
    type DomainId = zio.aws.elasticsearch.model.primitives.DomainId.Type
    object DomainName extends Subtype[String]
    type DomainName = zio.aws.elasticsearch.model.primitives.DomainName.Type
    object DomainNameFqdn extends Subtype[String]
    type DomainNameFqdn =
      zio.aws.elasticsearch.model.primitives.DomainNameFqdn.Type
    object DryRun extends Subtype[Boolean]
    type DryRun = zio.aws.elasticsearch.model.primitives.DryRun.Type
    object DurationValue extends Subtype[Long]
    type DurationValue =
      zio.aws.elasticsearch.model.primitives.DurationValue.Type
    object ElasticsearchVersionString extends Subtype[String]
    type ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives.ElasticsearchVersionString.Type
    object ErrorMessage extends Subtype[String]
    type ErrorMessage = zio.aws.elasticsearch.model.primitives.ErrorMessage.Type
    object ErrorType extends Subtype[String]
    type ErrorType = zio.aws.elasticsearch.model.primitives.ErrorType.Type
    object GUID extends Subtype[String]
    type GUID = zio.aws.elasticsearch.model.primitives.GUID.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId =
      zio.aws.elasticsearch.model.primitives.IdentityPoolId.Type
    object InstanceCount extends Subtype[Int]
    type InstanceCount =
      zio.aws.elasticsearch.model.primitives.InstanceCount.Type
    object InstanceRole extends Subtype[String]
    type InstanceRole = zio.aws.elasticsearch.model.primitives.InstanceRole.Type
    type Integer = Int
    object IntegerClass extends Subtype[Int]
    type IntegerClass = zio.aws.elasticsearch.model.primitives.IntegerClass.Type
    object Issue extends Subtype[String]
    type Issue = zio.aws.elasticsearch.model.primitives.Issue.Type
    object KmsKeyId extends Subtype[String]
    type KmsKeyId = zio.aws.elasticsearch.model.primitives.KmsKeyId.Type
    object LastUpdated extends Subtype[Instant]
    type LastUpdated = zio.aws.elasticsearch.model.primitives.LastUpdated.Type
    object LimitName extends Subtype[String]
    type LimitName = zio.aws.elasticsearch.model.primitives.LimitName.Type
    object LimitValue extends Subtype[String]
    type LimitValue = zio.aws.elasticsearch.model.primitives.LimitValue.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.elasticsearch.model.primitives.MaxResults.Type
    object MaximumInstanceCount extends Subtype[Int]
    type MaximumInstanceCount =
      zio.aws.elasticsearch.model.primitives.MaximumInstanceCount.Type
    object Message extends Subtype[String]
    type Message = zio.aws.elasticsearch.model.primitives.Message.Type
    object MinimumInstanceCount extends Subtype[Int]
    type MinimumInstanceCount =
      zio.aws.elasticsearch.model.primitives.MinimumInstanceCount.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.elasticsearch.model.primitives.NextToken.Type
    object NonEmptyString extends Subtype[String]
    type NonEmptyString =
      zio.aws.elasticsearch.model.primitives.NonEmptyString.Type
    object OwnerId extends Subtype[String]
    type OwnerId = zio.aws.elasticsearch.model.primitives.OwnerId.Type
    object PackageDescription extends Subtype[String]
    type PackageDescription =
      zio.aws.elasticsearch.model.primitives.PackageDescription.Type
    object PackageID extends Subtype[String]
    type PackageID = zio.aws.elasticsearch.model.primitives.PackageID.Type
    object PackageName extends Subtype[String]
    type PackageName = zio.aws.elasticsearch.model.primitives.PackageName.Type
    object PackageVersion extends Subtype[String]
    type PackageVersion =
      zio.aws.elasticsearch.model.primitives.PackageVersion.Type
    object Password extends Subtype[String]
    type Password = zio.aws.elasticsearch.model.primitives.Password.Type
    object PolicyDocument extends Subtype[String]
    type PolicyDocument =
      zio.aws.elasticsearch.model.primitives.PolicyDocument.Type
    object ReferencePath extends Subtype[String]
    type ReferencePath =
      zio.aws.elasticsearch.model.primitives.ReferencePath.Type
    object Region extends Subtype[String]
    type Region = zio.aws.elasticsearch.model.primitives.Region.Type
    object ReservationToken extends Subtype[String]
    type ReservationToken =
      zio.aws.elasticsearch.model.primitives.ReservationToken.Type
    object RoleArn extends Subtype[String]
    type RoleArn = zio.aws.elasticsearch.model.primitives.RoleArn.Type
    object S3BucketName extends Subtype[String]
    type S3BucketName = zio.aws.elasticsearch.model.primitives.S3BucketName.Type
    object S3Key extends Subtype[String]
    type S3Key = zio.aws.elasticsearch.model.primitives.S3Key.Type
    object SAMLEntityId extends Subtype[String]
    type SAMLEntityId = zio.aws.elasticsearch.model.primitives.SAMLEntityId.Type
    object SAMLMetadata extends Subtype[String]
    type SAMLMetadata = zio.aws.elasticsearch.model.primitives.SAMLMetadata.Type
    object ScheduledAutoTuneDescription extends Subtype[String]
    type ScheduledAutoTuneDescription =
      zio.aws.elasticsearch.model.primitives.ScheduledAutoTuneDescription.Type
    object ServiceUrl extends Subtype[String]
    type ServiceUrl = zio.aws.elasticsearch.model.primitives.ServiceUrl.Type
    object StartAt extends Subtype[Instant]
    type StartAt = zio.aws.elasticsearch.model.primitives.StartAt.Type
    object StartTimestamp extends Subtype[Instant]
    type StartTimestamp =
      zio.aws.elasticsearch.model.primitives.StartTimestamp.Type
    object StorageSubTypeName extends Subtype[String]
    type StorageSubTypeName =
      zio.aws.elasticsearch.model.primitives.StorageSubTypeName.Type
    object StorageTypeName extends Subtype[String]
    type StorageTypeName =
      zio.aws.elasticsearch.model.primitives.StorageTypeName.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.elasticsearch.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.elasticsearch.model.primitives.TagValue.Type
    object TotalNumberOfStages extends Subtype[Int]
    type TotalNumberOfStages =
      zio.aws.elasticsearch.model.primitives.TotalNumberOfStages.Type
    object UIntValue extends Subtype[Int]
    type UIntValue = zio.aws.elasticsearch.model.primitives.UIntValue.Type
    object UpdateTimestamp extends Subtype[Instant]
    type UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives.UpdateTimestamp.Type
    object UpgradeName extends Subtype[String]
    type UpgradeName = zio.aws.elasticsearch.model.primitives.UpgradeName.Type
    object UserPoolId extends Subtype[String]
    type UserPoolId = zio.aws.elasticsearch.model.primitives.UserPoolId.Type
    object Username extends Subtype[String]
    type Username = zio.aws.elasticsearch.model.primitives.Username.Type
  }
  type AdditionalLimitList = List[zio.aws.elasticsearch.model.AdditionalLimit]
  type AdvancedOptions = Map[String, String]
  type AutoTuneList = List[zio.aws.elasticsearch.model.AutoTune]
  type AutoTuneMaintenanceScheduleList =
    List[zio.aws.elasticsearch.model.AutoTuneMaintenanceSchedule]
  type ChangeProgressStageList =
    List[zio.aws.elasticsearch.model.ChangeProgressStage]
  type CompatibleElasticsearchVersionsList =
    List[zio.aws.elasticsearch.model.CompatibleVersionsMap]
  type DescribePackagesFilterList =
    List[zio.aws.elasticsearch.model.DescribePackagesFilter]
  type DescribePackagesFilterValues = List[DescribePackagesFilterValue]
  type DomainInfoList = List[zio.aws.elasticsearch.model.DomainInfo]
  type DomainNameList = List[DomainName]
  type DomainPackageDetailsList =
    List[zio.aws.elasticsearch.model.DomainPackageDetails]
  type ElasticsearchDomainStatusList =
    List[zio.aws.elasticsearch.model.ElasticsearchDomainStatus]
  type ElasticsearchInstanceTypeList =
    List[zio.aws.elasticsearch.model.ESPartitionInstanceType]
  type ElasticsearchVersionList = List[ElasticsearchVersionString]
  type EndpointsMap = Map[String, ServiceUrl]
  type FilterList = List[zio.aws.elasticsearch.model.Filter]
  type InboundCrossClusterSearchConnections =
    List[zio.aws.elasticsearch.model.InboundCrossClusterSearchConnection]
  type Issues = List[Issue]
  type LimitValueList = List[LimitValue]
  type LimitsByRole = Map[InstanceRole, zio.aws.elasticsearch.model.Limits]
  type LogPublishingOptions = Map[
    zio.aws.elasticsearch.model.LogType,
    zio.aws.elasticsearch.model.LogPublishingOption
  ]
  type OutboundCrossClusterSearchConnections =
    List[zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection]
  type PackageDetailsList = List[zio.aws.elasticsearch.model.PackageDetails]
  type PackageVersionHistoryList =
    List[zio.aws.elasticsearch.model.PackageVersionHistory]
  type RecurringChargeList = List[zio.aws.elasticsearch.model.RecurringCharge]
  type ReservedElasticsearchInstanceList =
    List[zio.aws.elasticsearch.model.ReservedElasticsearchInstance]
  type ReservedElasticsearchInstanceOfferingList =
    List[zio.aws.elasticsearch.model.ReservedElasticsearchInstanceOffering]
  type StorageTypeLimitList = List[zio.aws.elasticsearch.model.StorageTypeLimit]
  type StorageTypeList = List[zio.aws.elasticsearch.model.StorageType]
  type StringList = List[String]
  type TagList = List[zio.aws.elasticsearch.model.Tag]
  type UpgradeHistoryList = List[zio.aws.elasticsearch.model.UpgradeHistory]
  type UpgradeStepsList = List[zio.aws.elasticsearch.model.UpgradeStepItem]
  type ValueStringList = List[NonEmptyString]
}
