package zio.aws.elasticsearch.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.IntegerClass
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class SnapshotOptions(
    automatedSnapshotStartHour: Optional[IntegerClass] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions = {
    import SnapshotOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
      .builder()
      .optionallyWith(
        automatedSnapshotStartHour.map(value =>
          IntegerClass.unwrap(value): Integer
        )
      )(_.automatedSnapshotStartHour)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly =
    zio.aws.elasticsearch.model.SnapshotOptions.wrap(buildAwsValue())
}
object SnapshotOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.SnapshotOptions =
      zio.aws.elasticsearch.model
        .SnapshotOptions(automatedSnapshotStartHour.map(value => value))
    def automatedSnapshotStartHour: Optional[IntegerClass]
    def getAutomatedSnapshotStartHour: ZIO[Any, AwsError, IntegerClass] =
      AwsError.unwrapOptionField(
        "automatedSnapshotStartHour",
        automatedSnapshotStartHour
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ) extends zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly {
    override val automatedSnapshotStartHour: Optional[IntegerClass] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automatedSnapshotStartHour())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.IntegerClass(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.SnapshotOptions
  ): zio.aws.elasticsearch.model.SnapshotOptions.ReadOnly = new Wrapper(impl)
}
