package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.ConnectionAlias
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateOutboundCrossClusterSearchConnectionRequest(
    sourceDomainInfo: zio.aws.elasticsearch.model.DomainInformation,
    destinationDomainInfo: zio.aws.elasticsearch.model.DomainInformation,
    connectionAlias: ConnectionAlias
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest = {
    import CreateOutboundCrossClusterSearchConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest
      .builder()
      .sourceDomainInfo(sourceDomainInfo.buildAwsValue())
      .destinationDomainInfo(destinationDomainInfo.buildAwsValue())
      .connectionAlias(
        ConnectionAlias.unwrap(connectionAlias): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest.ReadOnly =
    zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest
      .wrap(buildAwsValue())
}
object CreateOutboundCrossClusterSearchConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest =
      zio.aws.elasticsearch.model
        .CreateOutboundCrossClusterSearchConnectionRequest(
          sourceDomainInfo.asEditable,
          destinationDomainInfo.asEditable,
          connectionAlias
        )
    def sourceDomainInfo: zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    def destinationDomainInfo
        : zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    def connectionAlias: ConnectionAlias
    def getSourceDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = ZIO.succeed(sourceDomainInfo)
    def getDestinationDomainInfo: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.DomainInformation.ReadOnly
    ] = ZIO.succeed(destinationDomainInfo)
    def getConnectionAlias: ZIO[Any, Nothing, ConnectionAlias] =
      ZIO.succeed(connectionAlias)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest
  ) extends zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest.ReadOnly {
    override val sourceDomainInfo
        : zio.aws.elasticsearch.model.DomainInformation.ReadOnly =
      zio.aws.elasticsearch.model.DomainInformation
        .wrap(impl.sourceDomainInfo())
    override val destinationDomainInfo
        : zio.aws.elasticsearch.model.DomainInformation.ReadOnly =
      zio.aws.elasticsearch.model.DomainInformation
        .wrap(impl.destinationDomainInfo())
    override val connectionAlias: ConnectionAlias =
      zio.aws.elasticsearch.model.primitives
        .ConnectionAlias(impl.connectionAlias())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest
  ): zio.aws.elasticsearch.model.CreateOutboundCrossClusterSearchConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
