package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.DomainName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainInfo(
    domainName: Optional[DomainName] = Optional.Absent,
    engineType: Optional[zio.aws.elasticsearch.model.EngineType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainInfo = {
    import DomainInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainInfo
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(engineType.map(value => value.unwrap))(_.engineType)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainInfo.ReadOnly =
    zio.aws.elasticsearch.model.DomainInfo.wrap(buildAwsValue())
}
object DomainInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainInfo =
      zio.aws.elasticsearch.model.DomainInfo(
        domainName.map(value => value),
        engineType.map(value => value)
      )
    def domainName: Optional[DomainName]
    def engineType: Optional[zio.aws.elasticsearch.model.EngineType]
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getEngineType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EngineType] =
      AwsError.unwrapOptionField("engineType", engineType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainInfo
  ) extends zio.aws.elasticsearch.model.DomainInfo.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val engineType: Optional[zio.aws.elasticsearch.model.EngineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.engineType())
        .map(value => zio.aws.elasticsearch.model.EngineType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainInfo
  ): zio.aws.elasticsearch.model.DomainInfo.ReadOnly = new Wrapper(impl)
}
