package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.NonEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Filter(
    name: Optional[NonEmptyString] = Optional.Absent,
    values: Optional[Iterable[NonEmptyString]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.Filter
      .builder()
      .optionallyWith(
        name.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            NonEmptyString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.Filter.ReadOnly =
    zio.aws.elasticsearch.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.Filter =
      zio.aws.elasticsearch.model
        .Filter(name.map(value => value), values.map(value => value))
    def name: Optional[NonEmptyString]
    def values: Optional[List[NonEmptyString]]
    def getName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[NonEmptyString]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.Filter
  ) extends zio.aws.elasticsearch.model.Filter.ReadOnly {
    override val name: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.NonEmptyString(value)
      )
    override val values: Optional[List[NonEmptyString]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives.NonEmptyString(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.Filter
  ): zio.aws.elasticsearch.model.Filter.ReadOnly = new Wrapper(impl)
}
