package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class NodeToNodeEncryptionOptionsStatus(
    options: zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions,
    status: zio.aws.elasticsearch.model.OptionStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus = {
    import NodeToNodeEncryptionOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
      .builder()
      .options(options.buildAwsValue())
      .status(status.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
      .wrap(buildAwsValue())
}
object NodeToNodeEncryptionOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus =
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus(
        options.asEditable,
        status.asEditable
      )
    def options
        : zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    def status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly
    def getOptions: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly
    ] = ZIO.succeed(options)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.elasticsearch.model.OptionStatus.ReadOnly] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
  ) extends zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly {
    override val options
        : zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions.ReadOnly =
      zio.aws.elasticsearch.model.NodeToNodeEncryptionOptions
        .wrap(impl.options())
    override val status: zio.aws.elasticsearch.model.OptionStatus.ReadOnly =
      zio.aws.elasticsearch.model.OptionStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.NodeToNodeEncryptionOptionsStatus
  ): zio.aws.elasticsearch.model.NodeToNodeEncryptionOptionsStatus.ReadOnly =
    new Wrapper(impl)
}
