package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Limits(
    storageTypes: Optional[Iterable[zio.aws.elasticsearch.model.StorageType]] =
      Optional.Absent,
    instanceLimits: Optional[zio.aws.elasticsearch.model.InstanceLimits] =
      Optional.Absent,
    additionalLimits: Optional[
      Iterable[zio.aws.elasticsearch.model.AdditionalLimit]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.Limits = {
    import Limits.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.Limits
      .builder()
      .optionallyWith(
        storageTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageTypes)
      .optionallyWith(instanceLimits.map(value => value.buildAwsValue()))(
        _.instanceLimits
      )
      .optionallyWith(
        additionalLimits.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.additionalLimits)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.Limits.ReadOnly =
    zio.aws.elasticsearch.model.Limits.wrap(buildAwsValue())
}
object Limits {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.Limits
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.Limits =
      zio.aws.elasticsearch.model.Limits(
        storageTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        instanceLimits.map(value => value.asEditable),
        additionalLimits.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def storageTypes
        : Optional[List[zio.aws.elasticsearch.model.StorageType.ReadOnly]]
    def instanceLimits
        : Optional[zio.aws.elasticsearch.model.InstanceLimits.ReadOnly]
    def additionalLimits
        : Optional[List[zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly]]
    def getStorageTypes: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.StorageType.ReadOnly
    ]] = AwsError.unwrapOptionField("storageTypes", storageTypes)
    def getInstanceLimits: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.InstanceLimits.ReadOnly
    ] = AwsError.unwrapOptionField("instanceLimits", instanceLimits)
    def getAdditionalLimits: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly
    ]] = AwsError.unwrapOptionField("additionalLimits", additionalLimits)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.Limits
  ) extends zio.aws.elasticsearch.model.Limits.ReadOnly {
    override val storageTypes
        : Optional[List[zio.aws.elasticsearch.model.StorageType.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.storageTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.StorageType.wrap(item)
          }.toList
        )
    override val instanceLimits
        : Optional[zio.aws.elasticsearch.model.InstanceLimits.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instanceLimits())
        .map(value => zio.aws.elasticsearch.model.InstanceLimits.wrap(value))
    override val additionalLimits
        : Optional[List[zio.aws.elasticsearch.model.AdditionalLimit.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.additionalLimits())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.AdditionalLimit.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.Limits
  ): zio.aws.elasticsearch.model.Limits.ReadOnly = new Wrapper(impl)
}
