package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{Region, DomainName, OwnerId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DomainInformation(
    ownerId: Optional[OwnerId] = Optional.Absent,
    domainName: DomainName,
    region: Optional[Region] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainInformation = {
    import DomainInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainInformation
      .builder()
      .optionallyWith(
        ownerId.map(value => OwnerId.unwrap(value): java.lang.String)
      )(_.ownerId)
      .domainName(DomainName.unwrap(domainName): java.lang.String)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainInformation.ReadOnly =
    zio.aws.elasticsearch.model.DomainInformation.wrap(buildAwsValue())
}
object DomainInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainInformation =
      zio.aws.elasticsearch.model.DomainInformation(
        ownerId.map(value => value),
        domainName,
        region.map(value => value)
      )
    def ownerId: Optional[OwnerId]
    def domainName: DomainName
    def region: Optional[Region]
    def getOwnerId: ZIO[Any, AwsError, OwnerId] =
      AwsError.unwrapOptionField("ownerId", ownerId)
    def getDomainName: ZIO[Any, Nothing, DomainName] = ZIO.succeed(domainName)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainInformation
  ) extends zio.aws.elasticsearch.model.DomainInformation.ReadOnly {
    override val ownerId: Optional[OwnerId] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerId())
      .map(value => zio.aws.elasticsearch.model.primitives.OwnerId(value))
    override val domainName: DomainName =
      zio.aws.elasticsearch.model.primitives.DomainName(impl.domainName())
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.elasticsearch.model.primitives.Region(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainInformation
  ): zio.aws.elasticsearch.model.DomainInformation.ReadOnly = new Wrapper(impl)
}
