package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{ReservationToken, GUID}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PurchaseReservedElasticsearchInstanceOfferingResponse(
    reservedElasticsearchInstanceId: Optional[GUID] = Optional.Absent,
    reservationName: Optional[ReservationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse = {
    import PurchaseReservedElasticsearchInstanceOfferingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse
      .builder()
      .optionallyWith(
        reservedElasticsearchInstanceId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceId)
      .optionallyWith(
        reservationName.map(value =>
          ReservationToken.unwrap(value): java.lang.String
        )
      )(_.reservationName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly =
    zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse
      .wrap(buildAwsValue())
}
object PurchaseReservedElasticsearchInstanceOfferingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse =
      zio.aws.elasticsearch.model
        .PurchaseReservedElasticsearchInstanceOfferingResponse(
          reservedElasticsearchInstanceId.map(value => value),
          reservationName.map(value => value)
        )
    def reservedElasticsearchInstanceId: Optional[GUID]
    def reservationName: Optional[ReservationToken]
    def getReservedElasticsearchInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceId",
        reservedElasticsearchInstanceId
      )
    def getReservationName: ZIO[Any, AwsError, ReservationToken] =
      AwsError.unwrapOptionField("reservationName", reservationName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse
  ) extends zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly {
    override val reservedElasticsearchInstanceId: Optional[GUID] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservedElasticsearchInstanceId())
        .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val reservationName: Optional[ReservationToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reservationName())
        .map(value =>
          zio.aws.elasticsearch.model.primitives.ReservationToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse
  ): zio.aws.elasticsearch.model.PurchaseReservedElasticsearchInstanceOfferingResponse.ReadOnly =
    new Wrapper(impl)
}
