package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ElasticsearchVersionString,
  DomainName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeElasticsearchInstanceTypeLimitsRequest(
    domainName: Optional[DomainName] = Optional.Absent,
    instanceType: zio.aws.elasticsearch.model.ESPartitionInstanceType,
    elasticsearchVersion: ElasticsearchVersionString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest = {
    import DescribeElasticsearchInstanceTypeLimitsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest
      .builder()
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .instanceType(instanceType.unwrap)
      .elasticsearchVersion(
        ElasticsearchVersionString.unwrap(
          elasticsearchVersion
        ): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest.ReadOnly =
    zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest
      .wrap(buildAwsValue())
}
object DescribeElasticsearchInstanceTypeLimitsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest =
      zio.aws.elasticsearch.model
        .DescribeElasticsearchInstanceTypeLimitsRequest(
          domainName.map(value => value),
          instanceType,
          elasticsearchVersion
        )
    def domainName: Optional[DomainName]
    def instanceType: zio.aws.elasticsearch.model.ESPartitionInstanceType
    def elasticsearchVersion: ElasticsearchVersionString
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getInstanceType: ZIO[
      Any,
      Nothing,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = ZIO.succeed(instanceType)
    def getElasticsearchVersion: ZIO[Any, Nothing, ElasticsearchVersionString] =
      ZIO.succeed(elasticsearchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest
  ) extends zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest.ReadOnly {
    override val domainName: Optional[DomainName] = zio.aws.core.internal
      .optionalFromNullable(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val instanceType
        : zio.aws.elasticsearch.model.ESPartitionInstanceType =
      zio.aws.elasticsearch.model.ESPartitionInstanceType
        .wrap(impl.instanceType())
    override val elasticsearchVersion: ElasticsearchVersionString =
      zio.aws.elasticsearch.model.primitives
        .ElasticsearchVersionString(impl.elasticsearchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest
  ): zio.aws.elasticsearch.model.DescribeElasticsearchInstanceTypeLimitsRequest.ReadOnly =
    new Wrapper(impl)
}
