package zio.aws.elasticsearch.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.elasticsearch.model.primitives.{UIntValue, UpdateTimestamp}
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class AutoTuneStatus(
    creationDate: UpdateTimestamp,
    updateDate: UpdateTimestamp,
    updateVersion: Option[UIntValue] = None,
    state: zio.aws.elasticsearch.model.AutoTuneState,
    errorMessage: Option[String] = None,
    pendingDeletion: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneStatus = {
    import AutoTuneStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneStatus
      .builder()
      .creationDate(UpdateTimestamp.unwrap(creationDate): Instant)
      .updateDate(UpdateTimestamp.unwrap(updateDate): Instant)
      .optionallyWith(
        updateVersion.map(value => UIntValue.unwrap(value): Integer)
      )(_.updateVersion)
      .state(state.unwrap)
      .optionallyWith(errorMessage.map(value => value: java.lang.String))(
        _.errorMessage
      )
      .optionallyWith(pendingDeletion.map(value => value: java.lang.Boolean))(
        _.pendingDeletion
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneStatus.wrap(buildAwsValue())
}
object AutoTuneStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneStatus =
      zio.aws.elasticsearch.model.AutoTuneStatus(
        creationDate,
        updateDate,
        updateVersion.map(value => value),
        state,
        errorMessage.map(value => value),
        pendingDeletion.map(value => value)
      )
    def creationDate: UpdateTimestamp
    def updateDate: UpdateTimestamp
    def updateVersion: Option[UIntValue]
    def state: zio.aws.elasticsearch.model.AutoTuneState
    def errorMessage: Option[String]
    def pendingDeletion: Option[Boolean]
    def getCreationDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(creationDate)
    def getUpdateDate: ZIO[Any, Nothing, UpdateTimestamp] =
      ZIO.succeed(updateDate)
    def getUpdateVersion: ZIO[Any, AwsError, UIntValue] =
      AwsError.unwrapOptionField("updateVersion", updateVersion)
    def getState: ZIO[Any, Nothing, zio.aws.elasticsearch.model.AutoTuneState] =
      ZIO.succeed(state)
    def getErrorMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getPendingDeletion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("pendingDeletion", pendingDeletion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneStatus
  ) extends zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly {
    override val creationDate: UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives
        .UpdateTimestamp(impl.creationDate())
    override val updateDate: UpdateTimestamp =
      zio.aws.elasticsearch.model.primitives.UpdateTimestamp(impl.updateDate())
    override val updateVersion: Option[UIntValue] = scala
      .Option(impl.updateVersion())
      .map(value => zio.aws.elasticsearch.model.primitives.UIntValue(value))
    override val state: zio.aws.elasticsearch.model.AutoTuneState =
      zio.aws.elasticsearch.model.AutoTuneState.wrap(impl.state())
    override val errorMessage: Option[String] =
      scala.Option(impl.errorMessage()).map(value => value: String)
    override val pendingDeletion: Option[Boolean] =
      scala.Option(impl.pendingDeletion()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneStatus
  ): zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly = new Wrapper(impl)
}
