package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AutoTuneOptionsStatus(
    options: Option[zio.aws.elasticsearch.model.AutoTuneOptions] = None,
    status: Option[zio.aws.elasticsearch.model.AutoTuneStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus = {
    import AutoTuneOptionsStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
      .builder()
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(status.map(value => value.buildAwsValue()))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly =
    zio.aws.elasticsearch.model.AutoTuneOptionsStatus.wrap(buildAwsValue())
}
object AutoTuneOptionsStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.AutoTuneOptionsStatus =
      zio.aws.elasticsearch.model.AutoTuneOptionsStatus(
        options.map(value => value.asEditable),
        status.map(value => value.asEditable)
      )
    def options: Option[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly]
    def status: Option[zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly]
    def getOptions: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly
    ] = AwsError.unwrapOptionField("options", options)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly
    ] = AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ) extends zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly {
    override val options
        : Option[zio.aws.elasticsearch.model.AutoTuneOptions.ReadOnly] = scala
      .Option(impl.options())
      .map(value => zio.aws.elasticsearch.model.AutoTuneOptions.wrap(value))
    override val status
        : Option[zio.aws.elasticsearch.model.AutoTuneStatus.ReadOnly] = scala
      .Option(impl.status())
      .map(value => zio.aws.elasticsearch.model.AutoTuneStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.AutoTuneOptionsStatus
  ): zio.aws.elasticsearch.model.AutoTuneOptionsStatus.ReadOnly = new Wrapper(
    impl
  )
}
