package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  Integer,
  UpdateTimestamp,
  GUID,
  ReservationToken
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ReservedElasticsearchInstance(
    reservationName: Option[ReservationToken] = None,
    reservedElasticsearchInstanceId: Option[GUID] = None,
    reservedElasticsearchInstanceOfferingId: Option[String] = None,
    elasticsearchInstanceType: Option[
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = None,
    startTime: Option[UpdateTimestamp] = None,
    duration: Option[Integer] = None,
    fixedPrice: Option[Double] = None,
    usagePrice: Option[Double] = None,
    currencyCode: Option[String] = None,
    elasticsearchInstanceCount: Option[Integer] = None,
    state: Option[String] = None,
    paymentOption: Option[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = None,
    recurringCharges: Option[
      Iterable[zio.aws.elasticsearch.model.RecurringCharge]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance = {
    import ReservedElasticsearchInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
      .builder()
      .optionallyWith(
        reservationName.map(value =>
          ReservationToken.unwrap(value): java.lang.String
        )
      )(_.reservationName)
      .optionallyWith(
        reservedElasticsearchInstanceId.map(value =>
          GUID.unwrap(value): java.lang.String
        )
      )(_.reservedElasticsearchInstanceId)
      .optionallyWith(
        reservedElasticsearchInstanceOfferingId.map(value =>
          value: java.lang.String
        )
      )(_.reservedElasticsearchInstanceOfferingId)
      .optionallyWith(elasticsearchInstanceType.map(value => value.unwrap))(
        _.elasticsearchInstanceType
      )
      .optionallyWith(
        startTime.map(value => UpdateTimestamp.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(duration.map(value => value: java.lang.Integer))(
        _.duration
      )
      .optionallyWith(fixedPrice.map(value => value: java.lang.Double))(
        _.fixedPrice
      )
      .optionallyWith(usagePrice.map(value => value: java.lang.Double))(
        _.usagePrice
      )
      .optionallyWith(currencyCode.map(value => value: java.lang.String))(
        _.currencyCode
      )
      .optionallyWith(
        elasticsearchInstanceCount.map(value => value: java.lang.Integer)
      )(_.elasticsearchInstanceCount)
      .optionallyWith(state.map(value => value: java.lang.String))(_.state)
      .optionallyWith(paymentOption.map(value => value.unwrap))(_.paymentOption)
      .optionallyWith(
        recurringCharges.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.recurringCharges)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly =
    zio.aws.elasticsearch.model.ReservedElasticsearchInstance
      .wrap(buildAwsValue())
}
object ReservedElasticsearchInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ReservedElasticsearchInstance =
      zio.aws.elasticsearch.model.ReservedElasticsearchInstance(
        reservationName.map(value => value),
        reservedElasticsearchInstanceId.map(value => value),
        reservedElasticsearchInstanceOfferingId.map(value => value),
        elasticsearchInstanceType.map(value => value),
        startTime.map(value => value),
        duration.map(value => value),
        fixedPrice.map(value => value),
        usagePrice.map(value => value),
        currencyCode.map(value => value),
        elasticsearchInstanceCount.map(value => value),
        state.map(value => value),
        paymentOption.map(value => value),
        recurringCharges.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def reservationName: Option[ReservationToken]
    def reservedElasticsearchInstanceId: Option[GUID]
    def reservedElasticsearchInstanceOfferingId: Option[String]
    def elasticsearchInstanceType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType]
    def startTime: Option[UpdateTimestamp]
    def duration: Option[Integer]
    def fixedPrice: Option[Double]
    def usagePrice: Option[Double]
    def currencyCode: Option[String]
    def elasticsearchInstanceCount: Option[Integer]
    def state: Option[String]
    def paymentOption: Option[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ]
    def recurringCharges
        : Option[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]]
    def getReservationName: ZIO[Any, AwsError, ReservationToken] =
      AwsError.unwrapOptionField("reservationName", reservationName)
    def getReservedElasticsearchInstanceId: ZIO[Any, AwsError, GUID] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceId",
        reservedElasticsearchInstanceId
      )
    def getReservedElasticsearchInstanceOfferingId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField(
        "reservedElasticsearchInstanceOfferingId",
        reservedElasticsearchInstanceOfferingId
      )
    def getElasticsearchInstanceType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ESPartitionInstanceType
    ] = AwsError.unwrapOptionField(
      "elasticsearchInstanceType",
      elasticsearchInstanceType
    )
    def getStartTime: ZIO[Any, AwsError, UpdateTimestamp] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getDuration: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("duration", duration)
    def getFixedPrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("fixedPrice", fixedPrice)
    def getUsagePrice: ZIO[Any, AwsError, Double] =
      AwsError.unwrapOptionField("usagePrice", usagePrice)
    def getCurrencyCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currencyCode", currencyCode)
    def getElasticsearchInstanceCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "elasticsearchInstanceCount",
        elasticsearchInstanceCount
      )
    def getState: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("state", state)
    def getPaymentOption: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = AwsError.unwrapOptionField("paymentOption", paymentOption)
    def getRecurringCharges: ZIO[Any, AwsError, List[
      zio.aws.elasticsearch.model.RecurringCharge.ReadOnly
    ]] = AwsError.unwrapOptionField("recurringCharges", recurringCharges)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ) extends zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly {
    override val reservationName: Option[ReservationToken] = scala
      .Option(impl.reservationName())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.ReservationToken(value)
      )
    override val reservedElasticsearchInstanceId: Option[GUID] = scala
      .Option(impl.reservedElasticsearchInstanceId())
      .map(value => zio.aws.elasticsearch.model.primitives.GUID(value))
    override val reservedElasticsearchInstanceOfferingId: Option[String] = scala
      .Option(impl.reservedElasticsearchInstanceOfferingId())
      .map(value => value: String)
    override val elasticsearchInstanceType
        : Option[zio.aws.elasticsearch.model.ESPartitionInstanceType] = scala
      .Option(impl.elasticsearchInstanceType())
      .map(value =>
        zio.aws.elasticsearch.model.ESPartitionInstanceType.wrap(value)
      )
    override val startTime: Option[UpdateTimestamp] = scala
      .Option(impl.startTime())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.UpdateTimestamp(value)
      )
    override val duration: Option[Integer] =
      scala.Option(impl.duration()).map(value => value: Integer)
    override val fixedPrice: Option[Double] =
      scala.Option(impl.fixedPrice()).map(value => value: Double)
    override val usagePrice: Option[Double] =
      scala.Option(impl.usagePrice()).map(value => value: Double)
    override val currencyCode: Option[String] =
      scala.Option(impl.currencyCode()).map(value => value: String)
    override val elasticsearchInstanceCount: Option[Integer] = scala
      .Option(impl.elasticsearchInstanceCount())
      .map(value => value: Integer)
    override val state: Option[String] =
      scala.Option(impl.state()).map(value => value: String)
    override val paymentOption: Option[
      zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
    ] = scala
      .Option(impl.paymentOption())
      .map(value =>
        zio.aws.elasticsearch.model.ReservedElasticsearchInstancePaymentOption
          .wrap(value)
      )
    override val recurringCharges
        : Option[List[zio.aws.elasticsearch.model.RecurringCharge.ReadOnly]] =
      scala
        .Option(impl.recurringCharges())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticsearch.model.RecurringCharge.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ReservedElasticsearchInstance
  ): zio.aws.elasticsearch.model.ReservedElasticsearchInstance.ReadOnly =
    new Wrapper(impl)
}
