package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteOutboundCrossClusterSearchConnectionResponse(
    crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse = {
    import DeleteOutboundCrossClusterSearchConnectionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse
      .builder()
      .optionallyWith(
        crossClusterSearchConnection.map(value => value.buildAwsValue())
      )(_.crossClusterSearchConnection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.ReadOnly =
    zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse
      .wrap(buildAwsValue())
}
object DeleteOutboundCrossClusterSearchConnectionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse =
      zio.aws.elasticsearch.model
        .DeleteOutboundCrossClusterSearchConnectionResponse(
          crossClusterSearchConnection.map(value => value.asEditable)
        )
    def crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ]
    def getCrossClusterSearchConnection: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ] = AwsError.unwrapOptionField(
      "crossClusterSearchConnection",
      crossClusterSearchConnection
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse
  ) extends zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.ReadOnly {
    override val crossClusterSearchConnection: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection.ReadOnly
    ] = scala
      .Option(impl.crossClusterSearchConnection())
      .map(value =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnection
          .wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse
  ): zio.aws.elasticsearch.model.DeleteOutboundCrossClusterSearchConnectionResponse.ReadOnly =
    new Wrapper(impl)
}
