package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  CreatedAt,
  CommitMessage,
  PackageVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PackageVersionHistory(
    packageVersion: Option[PackageVersion] = None,
    commitMessage: Option[CommitMessage] = None,
    createdAt: Option[CreatedAt] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory = {
    import PackageVersionHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory
      .builder()
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        commitMessage.map(value =>
          CommitMessage.unwrap(value): java.lang.String
        )
      )(_.commitMessage)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly =
    zio.aws.elasticsearch.model.PackageVersionHistory.wrap(buildAwsValue())
}
object PackageVersionHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.PackageVersionHistory =
      zio.aws.elasticsearch.model.PackageVersionHistory(
        packageVersion.map(value => value),
        commitMessage.map(value => value),
        createdAt.map(value => value)
      )
    def packageVersion: Option[PackageVersion]
    def commitMessage: Option[CommitMessage]
    def createdAt: Option[CreatedAt]
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getCommitMessage: ZIO[Any, AwsError, CommitMessage] =
      AwsError.unwrapOptionField("commitMessage", commitMessage)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory
  ) extends zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly {
    override val packageVersion: Option[PackageVersion] = scala
      .Option(impl.packageVersion())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PackageVersion(value)
      )
    override val commitMessage: Option[CommitMessage] = scala
      .Option(impl.commitMessage())
      .map(value => zio.aws.elasticsearch.model.primitives.CommitMessage(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.elasticsearch.model.primitives.CreatedAt(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageVersionHistory
  ): zio.aws.elasticsearch.model.PackageVersionHistory.ReadOnly = new Wrapper(
    impl
  )
}
