package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  PackageName,
  PackageDescription,
  CreatedAt,
  PackageVersion,
  LastUpdated,
  PackageID
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class PackageDetails(
    packageID: Option[PackageID] = None,
    packageName: Option[PackageName] = None,
    packageType: Option[zio.aws.elasticsearch.model.PackageType] = None,
    packageDescription: Option[PackageDescription] = None,
    packageStatus: Option[zio.aws.elasticsearch.model.PackageStatus] = None,
    createdAt: Option[CreatedAt] = None,
    lastUpdatedAt: Option[LastUpdated] = None,
    availablePackageVersion: Option[PackageVersion] = None,
    errorDetails: Option[zio.aws.elasticsearch.model.ErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.PackageDetails = {
    import PackageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.PackageDetails
      .builder()
      .optionallyWith(
        packageID.map(value => PackageID.unwrap(value): java.lang.String)
      )(_.packageID)
      .optionallyWith(
        packageName.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(
        packageDescription.map(value =>
          PackageDescription.unwrap(value): java.lang.String
        )
      )(_.packageDescription)
      .optionallyWith(packageStatus.map(value => value.unwrap))(_.packageStatus)
      .optionallyWith(createdAt.map(value => CreatedAt.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => LastUpdated.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        availablePackageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.availablePackageVersion)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.PackageDetails.ReadOnly =
    zio.aws.elasticsearch.model.PackageDetails.wrap(buildAwsValue())
}
object PackageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.PackageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.PackageDetails =
      zio.aws.elasticsearch.model.PackageDetails(
        packageID.map(value => value),
        packageName.map(value => value),
        packageType.map(value => value),
        packageDescription.map(value => value),
        packageStatus.map(value => value),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        availablePackageVersion.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def packageID: Option[PackageID]
    def packageName: Option[PackageName]
    def packageType: Option[zio.aws.elasticsearch.model.PackageType]
    def packageDescription: Option[PackageDescription]
    def packageStatus: Option[zio.aws.elasticsearch.model.PackageStatus]
    def createdAt: Option[CreatedAt]
    def lastUpdatedAt: Option[LastUpdated]
    def availablePackageVersion: Option[PackageVersion]
    def errorDetails: Option[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly]
    def getPackageID: ZIO[Any, AwsError, PackageID] =
      AwsError.unwrapOptionField("packageID", packageID)
    def getPackageName: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackageType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getPackageDescription: ZIO[Any, AwsError, PackageDescription] =
      AwsError.unwrapOptionField("packageDescription", packageDescription)
    def getPackageStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PackageStatus] =
      AwsError.unwrapOptionField("packageStatus", packageStatus)
    def getCreatedAt: ZIO[Any, AwsError, CreatedAt] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, LastUpdated] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getAvailablePackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField(
        "availablePackageVersion",
        availablePackageVersion
      )
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageDetails
  ) extends zio.aws.elasticsearch.model.PackageDetails.ReadOnly {
    override val packageID: Option[PackageID] = scala
      .Option(impl.packageID())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageID(value))
    override val packageName: Option[PackageName] = scala
      .Option(impl.packageName())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageName(value))
    override val packageType: Option[zio.aws.elasticsearch.model.PackageType] =
      scala
        .Option(impl.packageType())
        .map(value => zio.aws.elasticsearch.model.PackageType.wrap(value))
    override val packageDescription: Option[PackageDescription] = scala
      .Option(impl.packageDescription())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PackageDescription(value)
      )
    override val packageStatus
        : Option[zio.aws.elasticsearch.model.PackageStatus] = scala
      .Option(impl.packageStatus())
      .map(value => zio.aws.elasticsearch.model.PackageStatus.wrap(value))
    override val createdAt: Option[CreatedAt] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.elasticsearch.model.primitives.CreatedAt(value))
    override val lastUpdatedAt: Option[LastUpdated] = scala
      .Option(impl.lastUpdatedAt())
      .map(value => zio.aws.elasticsearch.model.primitives.LastUpdated(value))
    override val availablePackageVersion: Option[PackageVersion] = scala
      .Option(impl.availablePackageVersion())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PackageVersion(value)
      )
    override val errorDetails
        : Option[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly] = scala
      .Option(impl.errorDetails())
      .map(value => zio.aws.elasticsearch.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.PackageDetails
  ): zio.aws.elasticsearch.model.PackageDetails.ReadOnly = new Wrapper(impl)
}
