package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.CrossClusterSearchConnectionStatusMessage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OutboundCrossClusterSearchConnectionStatus(
    statusCode: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = None,
    message: Option[CrossClusterSearchConnectionStatusMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus = {
    import OutboundCrossClusterSearchConnectionStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
      .builder()
      .optionallyWith(statusCode.map(value => value.unwrap))(_.statusCode)
      .optionallyWith(
        message.map(value =>
          CrossClusterSearchConnectionStatusMessage.unwrap(
            value
          ): java.lang.String
        )
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly =
    zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
      .wrap(buildAwsValue())
}
object OutboundCrossClusterSearchConnectionStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus =
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus(
        statusCode.map(value => value),
        message.map(value => value)
      )
    def statusCode: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ]
    def message: Option[CrossClusterSearchConnectionStatusMessage]
    def getStatusCode: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = AwsError.unwrapOptionField("statusCode", statusCode)
    def getMessage
        : ZIO[Any, AwsError, CrossClusterSearchConnectionStatusMessage] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ) extends zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly {
    override val statusCode: Option[
      zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
    ] = scala
      .Option(impl.statusCode())
      .map(value =>
        zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatusCode
          .wrap(value)
      )
    override val message: Option[CrossClusterSearchConnectionStatusMessage] =
      scala
        .Option(impl.message())
        .map(value =>
          zio.aws.elasticsearch.model.primitives
            .CrossClusterSearchConnectionStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus
  ): zio.aws.elasticsearch.model.OutboundCrossClusterSearchConnectionStatus.ReadOnly =
    new Wrapper(impl)
}
