package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  NextToken,
  ElasticsearchVersionString
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListElasticsearchVersionsResponse(
    elasticsearchVersions: Option[Iterable[ElasticsearchVersionString]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse = {
    import ListElasticsearchVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse
      .builder()
      .optionallyWith(
        elasticsearchVersions.map(value =>
          value.map { item =>
            ElasticsearchVersionString.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.elasticsearchVersions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly =
    zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse
      .wrap(buildAwsValue())
}
object ListElasticsearchVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse =
      zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse(
        elasticsearchVersions.map(value => value),
        nextToken.map(value => value)
      )
    def elasticsearchVersions: Option[List[ElasticsearchVersionString]]
    def nextToken: Option[NextToken]
    def getElasticsearchVersions
        : ZIO[Any, AwsError, List[ElasticsearchVersionString]] =
      AwsError.unwrapOptionField("elasticsearchVersions", elasticsearchVersions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse
  ) extends zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly {
    override val elasticsearchVersions
        : Option[List[ElasticsearchVersionString]] = scala
      .Option(impl.elasticsearchVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticsearch.model.primitives
            .ElasticsearchVersionString(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticsearch.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListElasticsearchVersionsResponse
  ): zio.aws.elasticsearch.model.ListElasticsearchVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
