package zio.aws.elasticsearch.model
import zio.aws.elasticsearch.model.primitives.{
  ReferencePath,
  PackageName,
  DomainName,
  PackageVersion,
  LastUpdated,
  PackageID
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DomainPackageDetails(
    packageID: Option[PackageID] = None,
    packageName: Option[PackageName] = None,
    packageType: Option[zio.aws.elasticsearch.model.PackageType] = None,
    lastUpdated: Option[LastUpdated] = None,
    domainName: Option[DomainName] = None,
    domainPackageStatus: Option[
      zio.aws.elasticsearch.model.DomainPackageStatus
    ] = None,
    packageVersion: Option[PackageVersion] = None,
    referencePath: Option[ReferencePath] = None,
    errorDetails: Option[zio.aws.elasticsearch.model.ErrorDetails] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails = {
    import DomainPackageDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
      .builder()
      .optionallyWith(
        packageID.map(value => PackageID.unwrap(value): java.lang.String)
      )(_.packageID)
      .optionallyWith(
        packageName.map(value => PackageName.unwrap(value): java.lang.String)
      )(_.packageName)
      .optionallyWith(packageType.map(value => value.unwrap))(_.packageType)
      .optionallyWith(
        lastUpdated.map(value => LastUpdated.unwrap(value): Instant)
      )(_.lastUpdated)
      .optionallyWith(
        domainName.map(value => DomainName.unwrap(value): java.lang.String)
      )(_.domainName)
      .optionallyWith(domainPackageStatus.map(value => value.unwrap))(
        _.domainPackageStatus
      )
      .optionallyWith(
        packageVersion.map(value =>
          PackageVersion.unwrap(value): java.lang.String
        )
      )(_.packageVersion)
      .optionallyWith(
        referencePath.map(value =>
          ReferencePath.unwrap(value): java.lang.String
        )
      )(_.referencePath)
      .optionallyWith(errorDetails.map(value => value.buildAwsValue()))(
        _.errorDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly =
    zio.aws.elasticsearch.model.DomainPackageDetails.wrap(buildAwsValue())
}
object DomainPackageDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.DomainPackageDetails =
      zio.aws.elasticsearch.model.DomainPackageDetails(
        packageID.map(value => value),
        packageName.map(value => value),
        packageType.map(value => value),
        lastUpdated.map(value => value),
        domainName.map(value => value),
        domainPackageStatus.map(value => value),
        packageVersion.map(value => value),
        referencePath.map(value => value),
        errorDetails.map(value => value.asEditable)
      )
    def packageID: Option[PackageID]
    def packageName: Option[PackageName]
    def packageType: Option[zio.aws.elasticsearch.model.PackageType]
    def lastUpdated: Option[LastUpdated]
    def domainName: Option[DomainName]
    def domainPackageStatus
        : Option[zio.aws.elasticsearch.model.DomainPackageStatus]
    def packageVersion: Option[PackageVersion]
    def referencePath: Option[ReferencePath]
    def errorDetails: Option[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly]
    def getPackageID: ZIO[Any, AwsError, PackageID] =
      AwsError.unwrapOptionField("packageID", packageID)
    def getPackageName: ZIO[Any, AwsError, PackageName] =
      AwsError.unwrapOptionField("packageName", packageName)
    def getPackageType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.PackageType] =
      AwsError.unwrapOptionField("packageType", packageType)
    def getLastUpdated: ZIO[Any, AwsError, LastUpdated] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
    def getDomainName: ZIO[Any, AwsError, DomainName] =
      AwsError.unwrapOptionField("domainName", domainName)
    def getDomainPackageStatus
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.DomainPackageStatus] =
      AwsError.unwrapOptionField("domainPackageStatus", domainPackageStatus)
    def getPackageVersion: ZIO[Any, AwsError, PackageVersion] =
      AwsError.unwrapOptionField("packageVersion", packageVersion)
    def getReferencePath: ZIO[Any, AwsError, ReferencePath] =
      AwsError.unwrapOptionField("referencePath", referencePath)
    def getErrorDetails: ZIO[
      Any,
      AwsError,
      zio.aws.elasticsearch.model.ErrorDetails.ReadOnly
    ] = AwsError.unwrapOptionField("errorDetails", errorDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ) extends zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly {
    override val packageID: Option[PackageID] = scala
      .Option(impl.packageID())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageID(value))
    override val packageName: Option[PackageName] = scala
      .Option(impl.packageName())
      .map(value => zio.aws.elasticsearch.model.primitives.PackageName(value))
    override val packageType: Option[zio.aws.elasticsearch.model.PackageType] =
      scala
        .Option(impl.packageType())
        .map(value => zio.aws.elasticsearch.model.PackageType.wrap(value))
    override val lastUpdated: Option[LastUpdated] = scala
      .Option(impl.lastUpdated())
      .map(value => zio.aws.elasticsearch.model.primitives.LastUpdated(value))
    override val domainName: Option[DomainName] = scala
      .Option(impl.domainName())
      .map(value => zio.aws.elasticsearch.model.primitives.DomainName(value))
    override val domainPackageStatus
        : Option[zio.aws.elasticsearch.model.DomainPackageStatus] = scala
      .Option(impl.domainPackageStatus())
      .map(value => zio.aws.elasticsearch.model.DomainPackageStatus.wrap(value))
    override val packageVersion: Option[PackageVersion] = scala
      .Option(impl.packageVersion())
      .map(value =>
        zio.aws.elasticsearch.model.primitives.PackageVersion(value)
      )
    override val referencePath: Option[ReferencePath] = scala
      .Option(impl.referencePath())
      .map(value => zio.aws.elasticsearch.model.primitives.ReferencePath(value))
    override val errorDetails
        : Option[zio.aws.elasticsearch.model.ErrorDetails.ReadOnly] = scala
      .Option(impl.errorDetails())
      .map(value => zio.aws.elasticsearch.model.ErrorDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.DomainPackageDetails
  ): zio.aws.elasticsearch.model.DomainPackageDetails.ReadOnly = new Wrapper(
    impl
  )
}
