package zio.aws.elasticsearch.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListDomainNamesRequest(
    engineType: Option[zio.aws.elasticsearch.model.EngineType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest = {
    import ListDomainNamesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest
      .builder()
      .optionallyWith(engineType.map(value => value.unwrap))(_.engineType)
      .build()
  }
  def asReadOnly: zio.aws.elasticsearch.model.ListDomainNamesRequest.ReadOnly =
    zio.aws.elasticsearch.model.ListDomainNamesRequest.wrap(buildAwsValue())
}
object ListDomainNamesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticsearch.model.ListDomainNamesRequest =
      zio.aws.elasticsearch.model
        .ListDomainNamesRequest(engineType.map(value => value))
    def engineType: Option[zio.aws.elasticsearch.model.EngineType]
    def getEngineType
        : ZIO[Any, AwsError, zio.aws.elasticsearch.model.EngineType] =
      AwsError.unwrapOptionField("engineType", engineType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest
  ) extends zio.aws.elasticsearch.model.ListDomainNamesRequest.ReadOnly {
    override val engineType: Option[zio.aws.elasticsearch.model.EngineType] =
      scala
        .Option(impl.engineType())
        .map(value => zio.aws.elasticsearch.model.EngineType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticsearch.model.ListDomainNamesRequest
  ): zio.aws.elasticsearch.model.ListDomainNamesRequest.ReadOnly = new Wrapper(
    impl
  )
}
